# : ### FICHIER all.equal.nls2.s ###
# ----------------------------------------------------------
# compnls2: comparaison de composants non hierarchiques
#           de 2 nls2.objects
# ----------------------------------------------------------
compnls2 <- function(target, current, nom, ...)
{
	if (! is.null(target) && !is.null(current))	 {

	if ( !is.null(target) && is.null(current))
  {
  cat("Component", nom,"does not exist in 'current'\n", fill=T)
  return(FALSE)
  }

if (all(is.na(target)) && !all(is.na(current)))
  {
  cat("Component", nom,"present in 'current' and not in 'target'\n", fill=T)
  return(FALSE)
  }
if (!all(is.na(target)) && all(is.na(current)))
  {
  cat("Component", nom,"not present in 'current' and present in 'target'\n", fill=T)
  return(FALSE)
  }

if (is.vector(target) && (length(target) != length(current)))
  {
  cat("Differences in length of components", nom,"\n", fill=T)
  return(FALSE)
  }

if (is.matrix(target) && ( (ncol(target) != ncol(current)) || 
                                (nrow(target) != nrow(current)) ))
  {
  cat("Differences in dimension of components", nom,"\n", fill=T)
    return(FALSE)
  }

if (is.array(target) && any(dim(target) != dim(current)))
  {
  cat("Differences in dimension of components", nom,"\n", fill=T)
  return(FALSE)
  }


targp <- target[!is.na(target)]
curp <- current[!is.na(current)]

if ( (is.null(targp) && !is.null(curp)))
  {
  cat("Component", nom,"valued in 'current' and not in 'target'\n", fill=T)
  return(FALSE)
  }
if   ((!is.null(targp) && is.null(curp)))
  {
  cat("Component", nom,"not valued in 'current' and valued in 'target'\n", fill=T)
  return(FALSE)
  }
	# On compare aux names prs
	names(targp) <- NULL
	names(curp) <- NULL
	dimnames(targp) <- dimnames(curp) <- NULL
if (!is.null(targp) && (all.equal(targp , curp, ...) !=T))
  {
  cat("Differences in components", nom,"\n", fill=T)
  return(FALSE)
  }

	} # fin les 2 pas nuls
	
return(TRUE)
}

# ------------------------------------------------------
# all.equal.nls2: comparaison de 2 nls2.objects
# Les composants "call" and "model$file" ne sont pas compares
# Renvoie T si les objects sont identiques, F sinon
# Les arguments ...:	 voir ceux de la fonction R all.equal.numeric
# -----------------------------------------------------------              
all.equal.nls2<-function(target, current, ...)
{
if (is.null(class(current)) || (class(current) !="nls2") )
  {
  cat("'current' is not a 'nls2.object'\n", fill=T)
  return(F)
  }

target$call <-  current$call <-  NULL
target$model$file  <-  current$model$file  <-  NULL

Code  <-  TRUE

for (e in names(target))
  {
  if (!is.recursive(target[[e]]))
    Code  <-   compnls2(target[[e]], current[[e]],e, ...) && Code
  else
    {
    if (is.null(current[[e]]))
      {
      cat("Component", e,"does not exist in 'current'\n", fill=T)
      Code <- F
      }
    else
      {
      for (ee in names(target[[e]]))
        {
        if (!is.recursive(target[[e]][[ee]]))
          Code  <-   compnls2(target[[e]][[ee]], current[[e]][[ee]],
	        paste(e,"$",ee,sep=""), ...) && Code
        else
          {
          if (is.null(current[[e]][[ee]]))
            {
            cat("Component", paste(e,"$",ee,sep=""),"does not exist in 'current'\n", fill=T)
            Code <- F
            }
          else
            for (eee in names(target[[e]][[ee]]))
              Code  <-   compnls2(target[[e]][[ee]][[eee]],
	        current[[e]][[ee]][[eee]],
	         paste(e,"$",ee,"$",eee,sep=""), ...) && Code
          } # fin du else
        } # fin du for ee
      } # fin du else
    } # fin du else
  } # fin du for (e)
return(Code)
}
# : ### FICHIER coef.nls2.s ###
coef.nls2<-
function(nls2.object)
{
# ------------------------------------------
# extraire les valeurs estimees des Theta et eventuellement des Beta
# et le std.error de la derniere etape disponible
# d'un nls2.object
# On renvoie aussi, mais sans que print.coef l'ecrive :
# le code, le message, l'as.var et sigma2 
# ------------------------------------------
coef.object  <-  list(call=match.call())
class(coef.object) <- "coef.nls2"

if (!is.null(nls2.object$step3))
  {
  coef.object$theta <- nls2.object$step3$theta
  coef.object$beta <- nls2.object$step3$beta
  coef.object$sigma2 <- nls2.object$step3$sigma2
  coef.object$code <- nls2.object$step3$code
  coef.object$message <- nls2.object$step3$message

# on remplace les elements de as.var correspondant a Beta
# par leur valeur calculee a la precedente etape
# car, sinon, std.error est NA
if (!is.null(nls2.object$step3$as.var) &&
 !all(is.na(nls2.object$step3$as.var)) &&
    !all(is.na(nls2.object$step2$as.var)))
    {
    coef.object$as.var  <-  nls2.object$step3$as.var
    diago <- diag(nls2.object$step3$as.var)
    which <-  (1:length(diago))[is.na(diago)]
    diag2  <-  diag(nls2.object$step2$as.var)
    diago  <-  replace(diago, which, diag2[which])
    for (i in nrow(coef.object$as.var))
      coef.object$as.var[i,i]  <-  diago[i]
    coef.object$std.error <-sqrt(diago)
    names(coef.object$std.error) <-  dimnames(nls2.object$step2$as.var)[[1]]
    }
    
} # fin step3  
else
  {
    # step3 null
if (!is.null(nls2.object$step2))
  {
    # step3 nul et step 2 non null
  coef.object$theta <- nls2.object$step2$theta
  coef.object$beta <- nls2.object$step2$beta
  coef.object$sigma2 <- nls2.object$step2$sigma2
  coef.object$code <- nls2.object$step2$code
  coef.object$message <- nls2.object$step2$message

# on remplace les elements de as.var correspondant a Theta
# par leur valeur calculee a la precedente etape
# car, sinon, std.error est NA
  if (!is.null(nls2.object$step2$as.var) &&
      !all(is.na(nls2.object$step2$as.var)) &&
      !all(is.na(nls2.object$step1$as.var)))
    {
    coef.object$as.var  <-  nls2.object$step2$as.var
    diago <- diag(nls2.object$step2$as.var)
    which <-  (1:length(diago))[is.na(diago)]
    diag1  <-  diag(nls2.object$step1$as.var)
    diago  <-  replace(diago, which, diag1[which])
    for (i in nrow(coef.object$as.var))
      coef.object$as.var[i,i]  <-  diago[i]
    coef.object$std.error <-sqrt(diago)
    names(coef.object$std.error) <-  dimnames(nls2.object$step1$as.var)[[1]]
    }
} # step3 nul et step 2 non null
else
  {
   # step3 nul et step 2 null
    if (!is.null(nls2.object$step1$theta))
      {
       # step3 nul et step 2 null et step 1 non null
coef.object$theta <- nls2.object$step1$theta
coef.object$beta <- nls2.object$step1$beta
coef.object$sigma2 <- nls2.object$step1$sigma2
coef.object$code <- nls2.object$step1$code
coef.object$message <- nls2.object$step1$message
if (!is.null(nls2.object$step1$as.var) &&
   !all(is.na(nls2.object$step1$as.var)))
  {
    coef.object$as.var  <-  nls2.object$step1$as.var
  coef.object$std.error<-sqrt(diag(nls2.object$step1$as.var))
  names(coef.object$std.error) <-  dimnames(nls2.object$step1$as.var)[[1]]
  }
} # fin step3 nul et step 2 null et step 1 non null
    else
      {
        # step3 nul et step 2 null et step 1 null
  coef.object$theta <- nls2.object$theta
  coef.object$sigma2 <- nls2.object$sigma2
  coef.object$code <- nls2.object$code
  coef.object$message <- nls2.object$message
  if (!is.null(nls2.object$beta) && !all(is.na(nls2.object$beta)))
    {
    coef.object$beta <- nls2.object$beta
    }
  
  if (!is.null(nls2.object$as.var) &&
      !all(is.na(nls2.object$as.var)))
    {
    coef.object$as.var  <-  nls2.object$as.var
    coef.object$std.error <-sqrt(diag(nls2.object$as.var))
    names(coef.object$std.error) <-  dimnames(nls2.object$as.var)[[1]]
    }
  }
}
}
return(coef.object)

}
# : ### FICHIER fitted.nls2.s ###
fitted.nls2<-
function(nls2.object)
{
# extraire les valeurs ajustees de l'esperance, 
# et eventuellement de la variance et du sedo
# d'un nls2.object

fitted.object <- list(call = match.call())
class(fitted.object) <- "fitted.nls2"

# On teste la response par rapport a numeric car si null
# considre response.name
if (!is.null(nls2.object$step3))
   nls2.object$step3$response.name <-  NULL

if (!is.null(nls2.object$step3$response))
  {
  fitted.object$response <- nls2.object$step3$response
  if(!is.null(nls2.object$step3$variance)) 
    {
    fitted.object$variance <- nls2.object$step3$variance
    }
  if(!is.null(nls2.object$step3$FOdes))
    {
    fitted.object$odes <- nls2.object$step3$FOdes
    }
  }
else
  {
    #step3 null
if (!is.null(nls2.object$step2))
   nls2.object$step2$response.name <-  NULL

if (!is.null(nls2.object$step2$response))
  {
  fitted.object$response <- nls2.object$step2$response
  if(!is.null(nls2.object$step2$variance)) 
    {
    fitted.object$variance <- nls2.object$step2$variance
    }
  if(!is.null(nls2.object$step2$FOdes))
    {
    fitted.object$odes <- nls2.object$step2$FOdes
    }
}
else
  {
    # step3 null et step2 null
if (!is.null(nls2.object$step1))
   nls2.object$step1$response.name <-  NULL

if (!is.null(nls2.object$step1$response))
     {
fitted.object$response <- nls2.object$step1$response
if(!is.null(nls2.object$step1$variance)) 
  {
  fitted.object$variance <- nls2.object$step1$variance
  }
if(!is.null(nls2.object$step1$FOdes))
  {
  fitted.object$odes <- nls2.object$step1$FOdes
  }
}
   else
     {
       # step3 null et step2 null et step1 null
nls2.object$response.name <-  NULL
       if (!is.null(nls2.object$response))
  fitted.object$response <- nls2.object$response
  if(!is.null(nls2.object$variance)) 
    {
    fitted.object$variance <- nls2.object$variance
    }
  if(!is.null(nls2.object$FOdes))
    {
    fitted.object$FOdes <- nls2.object$FOdes
    }
  }
 }}

return(fitted.object)

}



# : ### FICHIER pldnls2.s ###
pldnls2<-function(data,response.name, X.names,
         smooth=F,
         labels=NULL,
         title="",
         figs=c(2,2),ask.pause=T, ask.modify=F, ...)
{
#***************************************************************************
# FONCTION:
# representation graphique des donnees:
# graphique de la variable
# reponse en fonction  des variables explicatives.
#
# data est un data.frame contenant eventuellement les "parameters"
#    curve et weight
#    Lorsque curve existe, en plus du graphique toutes courbes confondues, 
#    ou les points sont identifies par l'indice de courbe,
#    on obtient un graphique par courbe, les points etant identifies
#    par leurs identificateurs (c.a.d les labels du vecteur response).
#    Lorsqu'il y a plusieurs courbes et plusieurs variables,
#    on obtient, pour chaque variable, un graphique toutes courbes confondues,
#    les points etant identifies par l'indice de courbe,
#    et, pour chaque courbe, un graphique par variable les points etant
#    identifies par leurs identificateurs.
#
# ARGUMENTS:
# data: un data.frame
# response.name: nom du vecteur de data qui contient la variable reponse
# X.names: noms des vecteurs de data qui contiennent les variables independantes
# smooth: T si on veut un lissage des points (cf fonction S: lowess)
# title: titre des graphiques
# figs:
#  Quand il y a plusieurs courbes ou plusieurs variables,
#  plusieurs graphes sont traces; ceux-ci sont disposes sur la page 
#  selon la disposition indiquee dans figs: voir la fonction S "split.screen"
#  p 577 nouveau manuel et "par", page 528 ancien manuel S)
#  Exemple: figs=c(3,2) indique qu'on veut 3 graphes sur la longueur de l'ecran
#                        et 2 sur la largeur.
# ask.pause: TRUE si on veut qu'il y ait une pause entre chaque graphe
#     (fonctionnement interactif)
# ask.modify: TRUE si on veut rajouter ou supprimer des choses sur chaque graphe
#     (fonctionnement interactif): on demande de taper une expression valide:
#      par exemple, legend
# ...: n'importe quel autre argument reconnu par la fonction "plot"
# a l'exception de:
#      main, xlab,ylab,type,sub
#***************************************************************************

if(is.numeric(data))
     data <- sys.frame(data)


# Verification des arguments
# et determination des divers elements constituant les donnees:
# --------------------------------------------------------
z <- plsplitdnls2(data, response.name, X.names, labels=labels)
# On obtient:
# z$dmat:  matrice des va explicatives
# z$y: vecteur reponse,
# z$va.names: noms des variables explicatives
# z$response.name: nom du vecteur reponse,
# z$curve: noms des n indices indices de courbe
# z$labels: les labels sans ceux correspondant a des poids nuls


# Les identificateurs des points:
if (is.null(z$labels))
  z$labels <- rep("*", length(z$y))
else
  {
  if (length(z$labels) != length(z$y))
    stop("\n The length of the label vector does not match \n")
  }

if (ask.modify)
  ask.pause <- T

# Appel des fonctions de traces graphiques:
# ----------------------------------------
# Sauvegarde des parametres "par" courants :
if (is.R()) oldpar<-par(no.readonly=T)
	else oldpar<-par()

# On efface les graphes precedents:
close.screen(all=TRUE)

# parametres qui ne servent pas ici:
xfit <- yfit <- curvefit <- NULL
		
# Appel de la fonction qui gere les graphiques:
plnls2(z$dmat,  z$y, id=z$labels, z$curve,
	xfit, yfit, curvefit,
       title, z$va.names, response.name,
       jump=F, smooth=smooth,  ask.pause=ask.pause, ask.modify=ask.modify, figs,...)

# on efface les graphes precedents:
#erase.screen(0) 
close.screen(all=TRUE)

# restitution des parametres de plotting originaux:
par(oldpar) 
invisible()
}
# : ### FICHIER plfit.nls2.s ###
plfit <- function(x, ...)
  UseMethod("plfit")

plfit.default <- function(x,...)
  {
  if (!inherits(x,"nls2"))
    stop("This function is valid only on a 'nls2.object'")
  }

plfit.nls2<-function(nls2.object,
         step=nls2.object$nb.steps,
         wanted=list(O.F=T, X.OF=T),
         smooth=F, n.fitted=0,
	 labels=NULL,
         title="",
         figs=c(2,2),ask.pause=T, ask.modify=F, ...)

{
#***************************************************************************
# FONCTION:
# representations graphiques des valeurs observees
# de l'esperance en fonction des ajustees
# et, s'il n'y a qu'une variable explicative,
# des valeurs observees et ajustees de l'esperance en fonction des
# valeurs de la variable explicative
#
# ARGUMENTS:
# nls2.object: une sortie de la fonction nls2
# step: numero de l'etape (a partir de 1), en estimation alternee
# O.F: valeurs observees en fonction des ajustees
# X.OF: valeurs observees et ajustees en fonction de la variable explicative
#     valable que si une seule variable
# smooth: T si on veut un lissage des points (cf fonction S: lowess)
# labels, title, figs, ask, ... :voir fonction 'pld'
#***************************************************************************
# Verification des arguments:
# --------------------------
if ( !missing(step) && ( (step <= 0) || (step > nls2.object$nb.steps)))
  stop(paste("\nThe requested step", 
               step, "and the effective number of steps", nls2.object$nb.steps,
               "does not match\n "))

if ( !is.numeric(n.fitted) || (n.fitted<0) ||
	( (n.fitted>0) &&  (n.fitted<2)))
  stop(paste(
"Argument 'n.fitted',", n.fitted,
"must be an integer greater than 2\n"))
	
# Verification des donnees et
# determination des divers elements constituant les donnees:
# --------------------------------------------------------
  data <- plsplitoutnls2(nls2.object)

z <- plsplitdnls2(data, nls2.object$response.name, nls2.object$X.names, labels=labels)
# On obtient:
# z$dmat:  matrice des va explicatives
# z$y: vecteur reponse,
# z$va.names: noms des variables explicatives
# z$response.name: nom du vecteur reponse,
# z$curve: noms des n indices indices de courbe
# z$labels: les labels sans ceux correspondant a des poids nuls

# Mise en dimension n des ajustes:
# --------------------------------
# Les valeurs observees seront eventuellement lissees
# par une ligne pointillee, les ajustees seront toujours lissees
# par une ligne pleine
if (missing(step))
  {
   fittedf <-  fitted.nls2(nls2.object)$response
   theta <-  coef(nls2.object)$theta
 }
else
  {	
  fittedf <-  nls2.object[[paste("step",step,sep="")]]$response
  theta <- nls2.object[[paste("step",step,sep="")]]$theta
  }
		  	
if ( is.null(fittedf) || !is.numeric(fittedf) ||
    is.null(theta) || is.null(nls2.object$replications))
  stop("The nls2.object should contain the fitted values of the response, the estimated values of the parameters and the vector of replications")

fittedf <- rep(fittedf, nls2.object$replications)


n <- length(fittedf)
if (n != length(z$y))
  stop("\nThe 'nls2.object' and the 'data' does not match\n")


# Les identificateurs des points:
if (is.null(z$labels))
  z$labels <- rep("*", n)
else
  {
  if (length(z$labels) != n)
    stop("\n The length of the label vector does not match\n ")
  }


if (ask.modify)
  ask.pause <- T

# Appel des fonctions de traces graphiques:
# ----------------------------------------

# Sauvegarde des parametres "par" courants :
if (is.R()) oldpar<-par(no.readonly=T)
	else oldpar<-par()

# On efface les graphes precedents:
close.screen(all=TRUE)

if (!is.null(wanted$O.F) && wanted$O.F)
  {
  cat("\nPlots asked by the O.F option\n",fill=T)
  # Trace des observes en fonction des ajustes:
  plnls2(xmat=as.matrix(z$y),  y=fittedf, id=z$labels, curvey=z$curve,
	 xfit=NULL, yfit=NULL, curvefit=NULL,
           title,
           paste("observed values of ", z$response.name),
           "fitted values of the regression function",
           jump=F,
           smooth=smooth,
           ask.pause, ask.modify,
           figs, ...)
  }

if(!is.null(wanted$X.OF) && wanted$X.OF)
  {
  cat("\nPlots asked by the X.OF option\n",fill=T)
  if (ncol(z$dmat)>1)
    {
    warning("\nThe plot of the fitted values of the regression function cannot be asked when there are several independent variables\n")
    }
  else
    {
     # une seule variable: trace des valeurs observees et estimees de
     # de l'esperance en fonction de la variable:
    if (n.fitted>1)
      {
      # on genere de nouveaux points de calcul
       RetFit <-  cfitnls2(nls2.object,z,n.fitted,
	  theta,   beta=NULL, sigma2=NULL, calc.f=T, calc.v=F)
      xfit <- RetFit$xfit			
      curvefit <- RetFit$curvefit			
      yfit <- RetFit$yfit	
      } # fin de generation de nouveaux points
    else
      {
      yfit <- fittedf
      xfit <- z$dmat[,1]
      curvefit <- z$curve
      }			
    plnls2(as.matrix(z$dmat[,1]), z$y, z$labels, z$curve,
	  as.matrix(xfit), yfit, curvefit,
           title,
           z$va.names[1],
           paste("observed and fitted values of ", z$response.name),
           jump=F,
           smooth=smooth,
           ask.pause, ask.modify,
           figs, ...)
    }
  }


# on efface les graphes precedents:
#erase.screen(0) 
close.screen(all=TRUE)

# restitution des parametres de plotting originaux:
par(oldpar) 
invisible()
}

# -----------------------------------------------------------
# cfitnls2
# Generer une grille de calcul sur l'axe de la variable independente
# (supposee unique)
# et calculer f et/ou 	v(theta,beta)*sigma2
#	(poids supposes 1 sur la grille)				
# -----------------------------------------------------------
cfitnls2 <- function(nls2.object, z,
	  n.fitted, theta, beta, sigma2,
	  calc.f, calc.v)
{
# Initialisation des sorties:
xfit <- yfit <- varfit <- curvefit <- NULL
	
# Creation des donnees de toutes les  courbes:
if (is.null(z$curve))
  z$curve <- rep("a", n.fitted)	# valeur bidon

idc <- unique(z$curve) # noms des courbes
ncurves <-  length(idc)
for (ic in idc)
  {	
  v <- (z$curve==ic)
  xfit <-  c(xfit,
	seq(from=min(z$dmat[v==TRUE ,1]),
 	              to=max(z$dmat[v==TRUE ,1]),
	              length=n.fitted))
  } # fin for (ic in idc)

RetModel <- CrArbnls2(nls2.object$model, nls2.object$ctx.integ)
if (RetModel$CasSedo)	
  .C("debutOdesnls2")	

curvefit <- rep(idc, rep(n.fitted, ncurves))
n <- length(xfit)
	
dataplot <- data.frame( xfit,
        rep(1,n),
	curves=curvefit)
# valeurs bidon pour la reponse
names(dataplot) <- c(nls2.object$X.names, nls2.object$response.name, "curves")
initplotc(dataplot,nls2.object$X.names, nls2.object$response.name)
	
k <- as.integer(0)
	
if(RetModel$CasSedo)
  {
  #  Creation du contexte d'integration:
  crCtxIntegnls2(ncurves, n, RetModel, nls2.object$integ.ctx)
#  .Fortran("initlsoda <- ")
  LgDSedo <- as.integer(0)
  RetDim <- .C("initOdesnls2",
     pbase=as.integer(RetModel$NbTheta),
     k=as.integer(k),
     LgDSedo=as.integer(LgDSedo))
  Retf <-  odesplotcnls2(n , RetModel$NbTheta,
	           length(nls2.object$model$gamf), 
 	           theta, nls2.object$model$gamf)
  } #fin cas sedo
else
  {
  # faire ce qu'a fait crCtxIntegnls2:				
  # Creation de la trace et des donnees
 .C("initCalcnls2",   k=as.integer(k))
  Retf <-    fplotcnls2(n , RetModel$NbTheta,
	           length(nls2.object$model$gamf), 
	          theta, nls2.object$model$gamf)
  } # fin cas non sedo
		
if (calc.f)
  yfit <-  c(yfit, Retf$f)

if (calc.v && RetModel$YaCalcV)
  {
  varfit <-  c(varfit,
          vplotcnls2(n , RetModel$NbTheta, RetModel$NbBeta,
	           length(nls2.object$model$gamv), 
	          theta,
	          beta,
	          nls2.object$model$gamv,
	          Retf$f, Retf$df))
  }	# fin de (calc.v && YaCalcV)

# Desallouer les structures C creees:
if (RetModel$CasSedo)
  .C("delOdesnls2")
else			
  .C("delCalcnls2")

if (calc.v)
  {		
  if (!RetModel$YaCalcV)
    varfit <- rep(sigma2, (n.fitted*ncurves))
  else	
    varfit <-  varfit * sigma2
  }	
return(list(xfit=xfit, yfit=yfit, curvefit=curvefit, varfit=varfit))
}
# --------- fin de 	cfitnls2 --------------------------------	

# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++	
# initplotc
# Initialise les structures internes de NL:	
#     GNLControle, la trace, les donnees
# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++	
initplotc <- function(data, NomX, NomY)
{			

# Initialisation de GNLControle en ce qui concerne les messages
# -------------------------------------------------------------
check <-  options()$check
warn <-  options()$warn
.C("initcrolenls2",  as.integer(check), as.integer(warn))

# INITIALISATION DES STRUCTURES par les valeurs et tailles par defaut
# ------------------------------
.C("debutCalcnls2")
	
# Creation des donnees:
# -------------------
don <- crDatanls2(data,NomX, NomY)

invisible()
}
# ---------------- fin initplotc -------------------------------
	
# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++		
#  fplotcnls2:
#  calcule k valeurs de f et df, les x etant dans 
# la structure interne de NL:	 Data.XObs	 	
# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++		
fplotcnls2 <- function(k, NbTheta, NbGamF, Theta, GamF)
{
le <- 0
ie <- 0
f <- vector(mode="double", length=k)
df <- vector(mode="double", length=(k * NbTheta))
if(NbGamF==0)
  GamF <- 0
		
Ret <- .C("calcfnls2", 
   pbase=as.integer(NbTheta),
   nbgf=as.integer(NbGamF),
   Theta=as.double(Theta),
   GamF=as.double(GamF),
   f=as.double(f), df=as.double(df),
   le=as.integer(le), ie=as.integer(ie))
if(Ret$le !=0)
  {
  # Treatment of error:
  coderr <- c(
   "the function f", 
   "the function v",
   "the derivatives of f",
   "the derivatives of v against the theta parameters",
   "the derivatives of v against the beta parameters",
   "auxiliary variables",
   "the derivatives of auxiliary variables against the theta parameters",
   "the derivatives of auxiliary variables against the beta parameters",
   "auxiliary variables of the model of f",
   "auxiliary variables of the model of v")
  if (Ret$le <= length(coderr))
	    lieuerr <- coderr[Ret$le]
  else
    lieuerr <- "the model"

  stop(paste("\nError when calculating \n",
              lieuerr,"\n on observation",Ret$ie,
              "\n No valid returned value\n"))
  }
return(list(f=Ret$f, df=Ret$df)	)
	
}
# ----------------- fin de fplotcnls2 ---------------				

	
# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++		
#  vplotcnls2:
#  calcule k valeurs de v  les x etant dans 
# la structure interne de NL:	 Data.XObs	 	
# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++		
vplotcnls2 <- function(k, NbTheta, NbBeta, NbGamV,
	  Theta, Beta,  GamV, f, df)
{
if (NbGamV==0)
  GamV <- 0
if (NbBeta==0)
  Beta <- 0

			
le <- 0
ie <- 0
v <- vector(mode="double", length=k)
dtv <- vector(mode="double", length=(k * NbTheta))
dbv <- vector(mode="double", length=(k * NbBeta))
	
# Meme si NbGamF=0 et GamF=NULL, ca marche
Ret <- .C("calcvnls2", 
   pbase=as.integer(NbTheta),
   qbase=as.integer(NbBeta),
   nbgv=as.integer(NbGamV),
   Theta=as.double(Theta),
   Beta=as.double(Beta),
   GamV=as.double(GamV),
   f=as.double(f), df=as.double(df),
   v=as.double(v), dtv=as.double(dtv), dbv=as.double(dbv),	
   le=as.integer(le), ie=as.integer(ie))
				
if(Ret$le !=0)
  {
  # Treatment of error:
  coderr <- c(
   "the function f", 
   "the function v",
   "the derivatives of f",
   "the derivatives of v against the theta parameters",
   "the derivatives of v against the beta parameters",
   "auxiliary variables",
   "the derivatives of auxiliary variables against the theta parameters",
   "the derivatives of auxiliary variables against the beta parameters",
   "auxiliary variables of the model of f",
   "auxiliary variables of the model of v")
  if (Ret$le <= length(coderr))
	    lieuerr <- coderr[Ret$le]
  else
    lieuerr <- "the model"

  stop(paste("\nError when calculating \n",
              lieuerr,"\n on observation",Ret$ie,
              "\n No valid returned value\n"))
  }
return(list(v=Ret$v)	)
	
}
# ----------------- fin de vplotcnls2 ---------------				
	
# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++	
#  odesplotcnls2:
#  calcule k valeurs de f et df,
# quand cas sedo, les x etant dans 
# la structure interne de NL:	 Data.XObs
# les sorties etant aussi dans des structures internes	
# ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++		
odesplotcnls2 <- function(k, NbTheta, NbGamF, Theta, GamF)
{
le <- 0
ie <- 0
if (is.null(GamF))
  GamF <- 0
		
Ret <- .C("callOdesnls2",
   pbase=as.integer(NbTheta),
   nbgf=as.integer(NbGamF),
   Theta=as.double(Theta),
   GamF=as.double(GamF),
   le=as.integer(le), ie=as.integer(ie))
if(Ret$le !=0)
  {
  # Treatment of error:
  coderr <- c(
   "the function f", 
   "the function v",
   "the derivatives of f",
   "the derivatives of v against the theta parameters",
   "the derivatives of v against the beta parameters",
   "auxiliary variables",
   "the derivatives of auxiliary variables against the theta parameters",
   "the derivatives of auxiliary variables against the beta parameters",
   "auxiliary variables of the model of f",
   "auxiliary variables of the model of v")
  if (Ret$le <= length(coderr))
	    lieuerr <- coderr[Ret$le]
  else
    lieuerr <- "the model"

  stop(paste("\nError when calculating \n",
              lieuerr,"\n on observation",Ret$ie,
              "\n No valid returned value\n"))
  }

# Recuperation de f et df:
f <- vector(mode="double", length=k)
df <- vector(mode="double", length=(k * NbTheta))
Ret <-  .C("recupfdfnls2", 
	as.integer(k), as.integer(NbTheta),
             f= as.double(f), df=as.double(df))

# Mettre sous bonne dimension f, df:
if(all(Ret$df ==0)) 
  Ret$df  <- NA	
else
  Ret$df <- matrix(Ret$df, ncol=NbTheta, byrow=T)

if(all(Ret$f==0)) Ret$f  <- NA
				
return(list(f=Ret$f, df=Ret$df)	)
	
}
# ----------------- fin de odesplotcnls2 ---------------				
				
# : ### FICHIER plit.nls2.s ###
plit <- function(x, ...)
  UseMethod("plit")

plit.default <- function(x,...)
  {
  if (!inherits(x,"nls2"))
    stop("This function is valid only on a 'nls2.object'")
  }

plrnls2<-function(iscreen, res, NbIter,  nbscreens, figs, NomRes, 
	title,ask.pause,ask.modify,...)
{
#***************************************************************************
# plrnls2:
# trace graphique d'un resultat numerique en fonction des iterations
# fonction appelee par plit.nls2
#***************************************************************************
  screen(nbscreens[iscreen]) 
  cat(paste("\nPlot of",NomRes,"against iterations\n"),fill=T)

  plot(NbIter,res,
         title=title, xlab="iterations",ylab=NomRes,
         type="b",...)


   if (ask.modify)
      {
      plmodifynls2()
      }
    iscreen  <-  iscreen+1

  if  (iscreen > length(nbscreens))
    {
    if (ask.pause)
      {
      cat("Hit 'return' to erase the display and see the next plot\n",fill=T)
      z <- scan(n=1,what="any")
      }
#    erase.screen(0) # on efface les graphes precedents
     close.screen(all=TRUE)
     split.screen(figs)
     iscreen <- 1
    }
  return(iscreen)
}
# ---------------- fin fonction plrnls2 --------------------------


plpnls2<-function(Param, NbIter, nbpoints,figsE,ask.pause,ask.modify,...) 
{
#***************************************************************************
# plpnls2:
# trace graphique d'un parametre en fonction des iterations
# et de ses variations en fonction des iterations.
# fonction appelee par plit.nls2
#***************************************************************************
    varp <- Param[1:(nbpoints-1),]
    varp[varp==0] <- NA
    varp <-  (100*(Param[2:nbpoints,] - varp))/ varp
    varp[is.na(varp)]  <- 0
    varp <- matrix(varp, ncol=ncol(Param))
    # si peu de variation au cours des iterations, ne pas tracer le parametre
    l <- apply(varp,2,function(x) {all(x==0)})

    if (any(l))
      cat("\nThe parameters '", 
         dimnames(Param)[[2]][l],
         "' do not appear because they don't vary\n",fill=T)

    if (all(l))
       return(); # aucun parametre ne varie

    varp <- matrix(varp[,!l], nrow=nbpoints-1)
    Paramnoms <- dimnames(Param)[[2]][!l]

    # on fait 2 figures sur l'ecran: 1 pour mettre le graphique
    # l'autre pour la legende:
    close.screen(all=TRUE)
    nbscreens <- split.screen(figs=matrix(c(0,0.71,0.7,1,0,0,1,1),ncol=4))

    cat("\n Plots of % variation of the parameters against iterations\n",fill=T)
    screen(nbscreens[1])
    matplot(matrix(NbIter[2:nbpoints], ncol=1), varp, type = "l",
                                  xlab = "iterations", ylab = "% variation ", 
                                  lty = 1:ncol(varp), ...)
    screen(nbscreens[2])
    y <- c( rep(min(varp),nbpoints-2), max(varp))
    plot(NbIter[2:nbpoints],y, xlab = "", ylab = "", axes=F,type = "n", ...)
    legend(NbIter[2], max(varp), legend = Paramnoms, cex=1.8,
                            lty = 1:ncol(varp) , col=1:ncol(varp))

   if (ask.modify)
      {
      while(TRUE)
        {
        cat("\nHit an expression  for modifying the plot or 'return'\n",fill=T)
        l <- scan(n=1, what="character", sep="\n")
        if (length(l)==0)
          break
        eval(parse(text=l))
        }
      }

    if (ask.pause)
      {
      cat("Hit 'return' to erase the display and see the next plot\n",fill=T)
      z <- scan(n=1,what="any")
      }

    # on efface les graphes precedents:
#    erase.screen(0) # on efface les graphes precedents
     close.screen(all=TRUE)


    nbscreens <- split.screen(figs=c(1,1))
    cat("\n Plots of % variation of each parameter between 2 iterations\n",fill=T)
    screen(nbscreens[1])

    tvar <- t(varp)
	if (is.R()) {
    stars((abs(tvar) - min(abs(tvar)))/(max(abs(
                                        tvar)) - min(abs(tvar))), scale = F,
                                        labels = Paramnoms,
                                        main =
                                        "% variation of each parameter between 2 iterations"
                                        ) } else {
	    stars((abs(tvar) - min(abs(tvar)))/(max(abs(
                                        tvar)) - min(abs(tvar))), scale = F,
                                        labels = Paramnoms,
                                        head =
                                        "% variation of each parameter between 2 iterations"
                                        ) }

	     if (ask.modify)
        {
        while(TRUE)
          {
          cat("\nHit an expression  for modifying the plot or 'return'\n",fill=T)
          l <- scan(n=1, what="character", sep="\n")
          if (length(l)==0)
            break
          eval(parse(text=l))
          }
        }

    if (ask.pause)
      {
      cat("Hit 'return' to erase the display and see the next plot\n",fill=T)
      z <- scan(n=1,what="any")
      }
#     erase.screen(0)

    close.screen(all=TRUE)

    nbscreens <- split.screen(figs=figsE)
    iscreen <- 1
    cat("\n Plots of the parameters and the percentage of their variation against iterations\n",fill=T)

    for(i in 1:ncol(varp))
      {
      screen(nbscreens[iscreen])

      plot(NbIter, Param[,Paramnoms[i]],
                  type ="b", ylab = paste("values of",Paramnoms[i]), xlab = "iterations", ...)

     if (ask.modify)
        {
        while(TRUE)
          {
          cat("\nHit an expression  for modifying the plot or 'return'\n",fill=T)
          l <- scan(n=1, what="character", sep="\n")
          if (length(l)==0)
            break
          eval(parse(text=l))
          }
        }
      iscreen  <-  iscreen+1
      if  (iscreen > length(nbscreens))
        {
        if (ask.pause)
          {
          cat("Hit 'return' to erase the display and see the next plot\n",fill=T)
          z <- scan(n=1,what="any")
          }
#      erase.screen(0) # on efface les graphes precedents
       close.screen(all=TRUE)
       split.screen(figsE)	
        iscreen <- 1
        }

      screen(nbscreens[iscreen])
      plot(NbIter[2:nbpoints], tvar[i, ], 
                  type = "b", ylab = paste("% variation of",  Paramnoms[i]), xlab = "iterations", ...)
      if (ask.modify)
        {
        while(TRUE)
          {
          cat("\nHit an expression  for modifying the plot or 'return'\n",fill=T)
          l <- scan(n=1, what="character", sep="\n")
          if (length(l)==0)
            break
          eval(parse(text=l))
          }
        }
      iscreen  <-  iscreen+1

      if  (iscreen > length(nbscreens))
        {
        if (ask.pause)
          {
          cat("Hit 'return' to erase the display, or, if any, see the next plot\n",fill=T)
          z <- scan(n=1,what="any")
          }
#      erase.screen(0) # on efface les graphes precedents
       close.screen(all=TRUE)
       split.screen(figsE)
        iscreen <- 1
        }
      } # fin boucle sur le nombre de parametres

  if ((ask.pause) && (iscreen !=1))
    {
    cat("Hit 'return' to erase the display, or, if any, see the next plot\n",fill=T)
    z <- scan(n=1,what="any")
#      erase.screen(0) # on efface les graphes precedents
       close.screen(all=TRUE)
    }
}
# ---------------- fin fonction plpnls2 -------------------------------------

iternls2<-function(iterlist)
{
#***************************************************************************
# iternls2:
# extraire les composants d'une liste 'iters.sv' d'un 'nls2.object'
# fonction appelee par plit.nls2
#***************************************************************************

return(
  NbItSv=iterlist$nb.iters.sv,
  NbIter=iterlist$iter,
  CritStat=iterlist$stat.crit, CritArret=iterlist$stop.crit,
  Lambda=iterlist$lambda, Theta=iterlist$theta, Beta=iterlist$beta)
}

# ------------- fin fonction iternls2 -------------------------


plit.nls2<-function(nls2.object,
         step=nls2.object$nb.steps,
         wanted=list(num.res=T, estim=T),
         start=0,
         title="",
         figsR=c(3,1),figsE=c(1,2),ask.pause=T,ask.modify=F, ...)

{
#***************************************************************************
# FONCTION:
# representations graphiques en vue d'une etude des resultats
# de chaque iteration
#
# ARGUMENTS:
# nls2.object: une sortie de la fonction nls2
# step: numero de l'etape (a partir de 1), en estimation alternee
# start: numero de l'iteration (Attention, no et non pas l'indice)
#       a partir duquel on fait les traces graphiques
# num.res:T si trace de Lambda , CritArret, et si different de CritArret, CritStat
# estim: trace des parametres: si il y a plusieurs etapes, les theta 
# ne sont traces qu'aux etapes impaires et les Beta, qu'aux etapes paires
# title= titre des graphiques
# figsR= decoupage de l'ecran pour les traces des num.res
# figsE=decoupage de l'ecran pour les parametres
# autres parametres: voir pld
# 
#***************************************************************************


# Verification des arguments:
# --------------------------
if ( !missing(step) && ( (step <= 0) || (step > nls2.object$nb.steps)))
  stop(paste("\nThe requested step",
               step, "and the effective number of steps", nls2.object$nb.steps,
               "does not match \n"))

# Obtention des resultats par iteration:
# --------------------------------------
if (nls2.object$nb.steps>1) 
  {
  labetap <-  paste("step",step, sep="")
  if (is.null(nls2.object[[labetap]]$iters.sv)) 
    stop(paste("\n There is no iteration results in the 'nls2.object' for the step", step, "\n"))
  Iter <-  iternls2(nls2.object[[labetap]]$iters.sv)
  }
  
if (nls2.object$nb.steps==1)
  {
  if (is.null(nls2.object$iters.sv))
    stop("\n There is no iteration results in the 'nls2.object'\n")
  Iter  <- iternls2(nls2.object$iters.sv)
  }

# on met start dans une variable avec un autre nom
# sinon confusion avec la fonction Old-S de meme nom
starti <-  start
# les iterations a representer:
NbIter <- Iter$NbIter[Iter$NbIter>=starti]
nbpoints <- length(NbIter)
if (nbpoints==0)
  stop(paste("\n The 'start' parameter (",starti,
    ") must be greater than the last iteration number saved in the 'nls2.object' (",
     Iter$NbIter[Iter$NbItSv],")",sep=""))

if(nbpoints <=2)
  stop("\n The number of iterations to plotted must be greater than 2\n")


# Appel des fonctions de traces graphiques:
# ----------------------------------------

# Sauvegarde des parametres "par" courants :
if (is.R()) oldpar<-par(no.readonly=T)
	else oldpar<-par()

# On efface les graphes precedents:
close.screen(all=TRUE)

# Trace des resultats numeriques
# ------------------------------
if (!is.null(wanted$num.res) && wanted$num.res && (!is.null(Iter$Lambda) || !is.null(Iter$CritArret) || !is.null(Iter$CritStat)) )
  {
  nbscreens <- split.screen(figs=figsR)
  iscreen <- 1

  # LAMBDA:
  if (!is.null(Iter$Lambda))
    {
    iscreen <- plrnls2(iscreen=iscreen,res=Iter$Lambda[Iter$NbIter>=starti],
            NbIter=NbIter,  nbscreens=nbscreens, figsR,NomRes="lambda", 
            title=title, ask.pause=ask.pause,ask.modify=ask.modify,...)
    } # fin Lambda
  
  # CRITARRET:
  if (!is.null(Iter$CritArret))
    {
    iscreen <- plrnls2(iscreen=iscreen,res=Iter$CritArret[Iter$NbIter>=starti],
            NbIter=NbIter,  nbscreens=nbscreens, figsR, NomRes="stop.crit", 
            title=title, ask.pause=ask.pause,ask.modify=ask.modify,...)
    } # fin CritArret
  
  #CRITSTAT:
  if (!is.null(Iter$CritStat) && (all(Iter$CritStat!=Iter$CritArret)))
    {
    iscreen <- plrnls2(iscreen=iscreen,res=Iter$CritStat[Iter$NbIter>=starti],
            NbIter=NbIter,  nbscreens=nbscreens, figsR,NomRes="stat.crit", 
            title=title, ask.pause=ask.pause,ask.modify=ask.modify,...)
    } # fin CritStat

  if ((ask.pause) && (iscreen !=1))
    {
    cat("Hit 'return' to erase the display, or, if any, see the next plot\n",fill=T)
    z <- scan(n=1,what="any")
#    erase.screen(0) # on efface les graphes precedents
# Pas besoin de faire close.screen, cf ci-dessous
    }

  } # fin num.res

# on efface les graphes precedents:
close.screen(all=TRUE)

if (!is.null(wanted$estim) && wanted$estim)
  {
  # THETA
  if ((step !=2) && !is.null(Iter$Theta))
    {
    Theta <- matrix(Iter$Theta[Iter$NbIter>=starti,],ncol=ncol(Iter$Theta))
    dimnames(Theta) <-  list(dimnames(Iter$Theta)[[1]][Iter$NbIter>=starti],
                         dimnames(Iter$Theta)[[2]])
    plpnls2(Theta,
                    NbIter, nbpoints,figsE, ask.pause,ask.modify,...)
    }
  # BETA
  if ( ( (step ==2) || ((step==1) && (nls2.object$nb.steps==1))) &&
       all(!is.na(Iter$Beta)) && !is.null(Iter$Beta) )
    {
    Beta <- matrix(Iter$Beta[Iter$NbIter>=starti,],ncol=ncol(Iter$Beta))
    dimnames(Beta) <-  list(dimnames(Iter$Beta)[[1]][Iter$NbIter>=starti],
                         dimnames(Iter$Beta)[[2]])
    plpnls2(Beta,
                    NbIter, nbpoints,figsE, ask.pause,ask.modify,...)
    }
  } # Fin estim

# on efface les graphes precedents:
# erase.screen(0)
close.screen(all=TRUE)

# restitution des parametres de plotting originaux:
par(oldpar) 
invisible()
}
# : ### FICHIER plnls2.s ###
pl1vnls2<-function(x,y,id,ncurvey,
	     xfit, yfit,ncurvefit,
	     jump,
	     title, xlab,ylab, smooth, ...)
{
#***************************************************************************
# FONCTION pl1vnls2:
# representation graphique des donnees 
# d'une courbe et d'une variable en abscisse
#***************************************************************************
n <- length(x)
nfit <- length(xfit)
		
if (jump && (n<3))
  {	
  # residus(i) en fonction residus(i-1)
  warning(paste("Graph not possible: only", n, "points\n"))
  return()
  } # fin de jump

if (nfit==0)
  {
  finxfit <- 1
  debyfit <- 0
  }
else
  {
  finxfit <- nfit-jump
  debyfit <- 1+jump
  }
							
# On fait le cadre sans mettre les points:
plot(x[1:(n-jump)],y[(1+jump):n],
      xlim=c(min(x[1:(n-jump)],xfit[1:finxfit]),
	     max(x[1:(n-jump)],xfit[1:finxfit])),
      ylim=c(min(y[(1+jump):n],yfit[debyfit:nfit]),
	     max(y[(1+jump):n],yfit[debyfit:nfit])),
      main=title, xlab=xlab, ylab=ylab,type="n",...)

# Rajout de l'identificateur des lgid premiers points sur le graphe:
par(adj=.5)
text(x[1:(n-jump)] ,y[(1+jump):n], labels=id[(1+jump):n])

	
# Lissage des lgid premiers points: toujours des observes ou empiriques
# lty: type de ligne pour le lissage (voir par: 1=ligne pleine, 2=pointilles)
# si une courbe: des pointilles
# si plusieurs courbes sur le meme graphe, lty=1 a nombre de courbes
if (smooth)
  {
  if (length(ncurvey)==1)
    {
    # une courbe: des pointilles
    lines(lowess(x[1:(n-jump)], y[(1+jump):n]), lty=2)
    }
  else
    {
    # lissage par courbe
    lty <- 1
    ideb <- 1	
    for (i in ncurvey)
      {
      ifin <-  ideb+i-1
      lines(lowess(x[ideb:(ifin-jump)],y[(ideb+jump):ifin]), lty=lty)
      lty <- lty+1
      ideb <- ifin+1
      }
    }
  } # fin smooth


# Les ajustes:
if (!is.null(xfit))
  {
   # Rajouter (xfit,yfit) en joignant les points: 
   # si une courbe: 1 ligne pleine
   # si plusieurs courbes sur le meme graphe, lty=1 a nombre de courbes
  if (length(ncurvefit)==1)
    {
    # une courbe: 1 ligne pleine
    # il faut trier les points quand pas de lissage
    xg <- 	xfit[1:(nfit-jump)]
    yg <- 	yfit[(1+jump):nfit]
    ordre <-  order(xg)
    lines(xg[ordre],yg[ordre], lty=1)
    }
  else
    {
    # joindre par courbe
    ideb <- 1
    lty <- 1
    for (i in ncurvefit)
      {
      ifin <-  ideb+i-1
      xg <-  xfit[ideb:(ifin-jump)]
      ordre <-  order(xg)
      yg <- y[(ideb+jump):ifin]
      lines(xg[ordre],yg[ordre], lty=lty)
      lty <- lty+1
      ideb <- ifin+1
      }
    } # fin plusieurs courbes
  } # fin (lgid < lgy)

invisible()
}
# ------------ fin fonction pl1vnls2 ------------------------#


# ---------------plmodifynls2 ------------------------------------
#  FONCTION plmodifynls2:
# gere la possibilite pour l'usager de taper une S-expression pour modifier
# le dession (ou faire autre chose)
# -----------------------------------------------------------------------
plmodifynls2 <- function()
     {
      # on ote l'option "error" pour que l'utilisateur puisse recommencer
      # a taper s'il fait une erreur:
#      restart(TRUE)
      oldopts  <- options(error=NULL) # on ote la creation du dump.calls
      on.exit(options(oldopts))
      while(TRUE)
        {
        cat("\nHit an S-expression or 'return'\n",fill=T)
        l <- scan(n=1, what="character", sep="\n")
        if (length(l)==0)
          break
        eval(parse(text=l))
        }
      }
# -------------- fin fonction plmodifynls2  ------------ #




pl1cnls2<-function(xmat,y, id,  ncurvey,
	         xfit, yfit, ncurvefit,
	          jump,
                  title, xlab, ylab,
                 smooth,   ask.pause, ask.modify,
                 boucle, iscreen,nbscreens, figs, ...)
{
#***************************************************************************
# FONCTION pl1cnls2:
# representation graphique 
# de une ou plusieurs variables 
# pour une courbe (ou plusieurs sur le meme graphe)
# ARGUMENTS: 
# voir fonction 'plnls2'
# boucle: TRUE si cette fonction est appelee dans une boucle
# et qu'il ne faut demander a l'utilisateur s'il vaut effacer le graphe
# que si l'ecran est plein et non pas apres chaque graphe
# iscreen: indice du graphe courant (sert quand plusieurs graphes sur l'ecran)
#***************************************************************************

  for (i in seq(1:length(xlab)))
    {
    screen(nbscreens[iscreen])
    pl1vnls2(xmat[,i],  y, id, ncurvey,
	     xfit, yfit,ncurvefit, jump,
	     title, xlab=xlab[i], ylab=ylab, smooth, ...)

    if (ask.modify)
      {
      plmodifynls2()
      }
    iscreen  <-  iscreen+1

    if  (iscreen > length(nbscreens))
      {
      if (ask.pause)
        {
        cat("Hit 'return' to erase the display, or, if any, see the next plot\n",fill=T)
        z <- scan(n=1,what="any")
        }
#      erase.screen(0) # on efface les graphes precedents
       close.screen(all=TRUE)
       split.screen(figs)
      iscreen <- 1
      }
    } # fin boucle sur length(xvar)

# si iscreen=1, c'est que ca a deja ete demande dans la boucle
if ( (iscreen !=1) && ask.pause && !boucle )
  {
  cat("Hit 'return' to erase the display, or, if any, see the next plot\n",fill=T)
  z <- scan(n=1,what="any")
  }

return(iscreen)

}
# ------------ fin fonction pl1cnls2 ------------------------#


plnls2<-function(xmat,y, id, curvey,
	         xfit, yfit, curvefit,
                 title, xlab, ylab,
                 jump, smooth,  ask.pause, ask.modify,
                 figs, ...)
{
#***************************************************************************
# FONCTION plnls2:
# representation graphique des donnees 
# de une ou plusieurs courbes en fonction de une ou plusieurs variables
# ARGUMENTS:
# xmat: matrice des valeurs en abscisse
# y: vecteurs des valeurs en ordonnee (points ou lisses si smooth)
# id: vecteur de chaines de caracteres
#       correspondant aux identificateurs des points
# curvey:  vecteur de chaines de caracteres
#       correspondant aux identificateurs de courbe des points (xmat,y)
# xfit, yfit, curvefit:	 eventuellement, les points a joindre par une ligne
# 	
# title: titre des graphiques
# xlab: chaine de caracteres ou vecteur de chaines de caracteres
#       correspondant aux labels en abscisse
#       si ncol(xmat)>1, length(xlab)=ncol(xmat)
# ylab: chaine de caracteres correspondant au label en ordonnee
# Si jump, on ote le 1ier 'y' et le 1ier 'id' et le dernier 'x'
# (jump=T quand on veut le graphe des residus(i) en fonction des residus(i-1)
# smooth: si on veut un lissage de certains points (voir fonction 'pl1vnls2')
# figs, ask.pause,  ask.modify,... :voir fonction 'pld'
#***************************************************************************

# Quand il y a plusieurs variables, on met plusieurs graphes sur la page:
close.screen(all=TRUE)

if (length(xlab)>1)
  nbscreens <- split.screen(figs=figs)
else
  {
  # il n'y a qu'un graphe
  if (!is.matrix(figs))
    {
    # cas ou on demande l'ecran entier
    nbscreens <- split.screen(c(1, 1))
    }
  else
    {
    # cas ou l'ecran est determine par un figs donne par l'utilisateur
    # on prend l'espace total de toutes les figures
    m <- matrix(c(min(figs[,1]), max(figs[,2]), min(figs[,3]),max(figs[,4])),
       nrow=1)
    nbscreens <- split.screen(m)
    }
  }

	
n <- nrow(xmat)
	
if (is.null(curvey))
  {
  # une seule courbe:
  # ----------------
  pl1cnls2(xmat, y, id, ncurvey=n,
	   xfit,yfit, ncurvefit=n,
                 jump,	
                 title, xlab, ylab,
                 smooth,   ask.pause, ask.modify,
                 boucle=F, iscreen=1,nbscreens, figs, ...)
  }

else
  {
  # Plusieurs courbes:
  # ------------------
  # Trace de toutes les courbes sur le (les) meme(s) graphe(s),
  # les points etant identifies par l'identificateur de courbe
  subtitle <-  "curve identifiers"
  # ncurvey:	nbre de points par courbe
  idc <- unique(curvey) # noms des courbes
  ncurvey <- vector(mode="integer", length=length(idc))
  ncurvefit <- vector(mode="integer", length=length(idc))
  for (ic in 1:length(idc))
    {
    v <- (curvey==idc[ic])
    ncurvey[ic] <-  length(v[v==TRUE])
    if (!is.null(curvefit))
      {
      v <- (curvefit==idc[ic])
      ncurvefit[ic] <-  length(v[v==TRUE])
      }
    else
      ncurvefit <- NULL		
    } # fin de for ic

  iscreen <- pl1cnls2(xmat, y, id=curvey,ncurvey,
	         xfit, yfit,  ncurvefit,
	         jump,
                 title, xlab, ylab,
                 smooth,  ask.pause,  ask.modify,
                  boucle=F, iscreen=1,nbscreens, figs,sub=subtitle, ...)
  
  
  # Trace de chaque courbe: plusieurs graphes dans la page,
  # les points etant identifies par id:
  close.screen(all=TRUE)
  nbscreens <- split.screen(figs)
  par(adj=.5)
  iscreen <- 1
  
  deby <- debfit <- 1
  for (c in 1:length(idc)) 
    {
    boucle <- T 	
    if (length(xlab)>1)
      {
      # On repart du debut de l'ecran a chaque courbe
      # boucle=F:demander si on veut effacer apres chaque appel a pl1c	
      deb.screen <- 1
      boucle  <- F
      }		
    else
      {
      # une seule va: on met plusieurs courbes sur le meme ecran
      # ne demander si on veut effacer que si on est a la derniere
      # courbe
      deb.screen <- iscreen 
      if (c == length(idc))
        boucle  <- F
      }
    finy <- deby + ncurvey[c] -1
    if (is.null(xfit))
      {		
      iscreen <-  pl1cnls2(
	             as.matrix(xmat[(deby:finy),]), 
	                y[deby:finy], id[deby:finy], ncurvey[c],
	              xfit,yfit,ncurvefit,
                      jump,	
                      title,xlab, ylab,
                      smooth, ask.pause,  ask.modify,
                      boucle=boucle,
	     iscreen=deb.screen,nbscreens,figs,sub=paste("curve",idc[c]), ...)
      }	
    else	
      {
      finfit <- debfit + ncurvefit[c] -1
      iscreen <-  pl1cnls2(
	             as.matrix(xmat[(deby:finy),]), 
	                y[deby:finy], id[deby:finy], ncurvey[c],
	              as.matrix(xfit[(debfit:finfit),]),
        	         yfit[debfit:finfit],ncurvefit[c],
	               jump,
                      title,xlab, ylab, 
                      smooth,  ask.pause,  ask.modify,
                      boucle=boucle,
	iscreen=deb.screen,nbscreens,figs,sub=paste("curve",idc[c]), ...)
      debfit <-  finfit+1	
      }				

    deby <-  finy+1	
    } # fin boucle sur les courbes
  } # fin du cas plusieurs courbes
  close.screen(all=TRUE)

invisible()
}
# ------------ fin fonction plnls2 ------------------------#
# : ### FICHIER plres.nls2.s ###
plres <- function(x, ...)
  UseMethod("plres")

plres.default <- function(x,...)
  {
  if (!inherits(x,"nls2"))
    stop("This function is valid only on a 'nls2.object'")
  }

plres.nls2<-function(nls2.object,
         step=nls2.object$nb.steps,
         wanted=list(F.R=T, R.R=T, I.R=F, X.R=F, V.R2=F),
         absolute=F, st=F,
         smooth=F, labels=NULL,
         title="",
         figs=c(2,2),ask.pause=T, ask.modify=F, ...)
{
#***************************************************************************
# FONCTION:
# representations graphiques en vue d'une etude des residus
# relative a des donnees etudiees par nls2:
#
# ARGUMENTS:
# nls2.object: une sortie de la fonction nls2
# step: numero de l'etape (a partir de 1), en estimation alternee
# F.R: TRUE  si on plit.nls2.s veut le graphe des residus
#      en fonction des valeurs observees de reponse
# R.R: TRUE  si on veut le graphe des residus(i)
#      en fonction des residus(i-1)
# I.R: TRUE  si on veut le graphe des residus(i)
#      en fonction de i
# X.R: TRUE  si on veut le graphe des residus(i)
#      en fonction des variables explicatives 
# V.R2: TRUE  si on veut le graphe des carres des residus
#      en fonction des  valeurs de la variance
# (pas valable avec l'option 'st')
# absolute: TRUE si, pour les graphes correspondant a F.R, I.R, X.R, on veut
#         representer les valeurs absolues des residus 
# st: TRUE  si on veut representer les valeurs des residus reduits
# smooth: TRUE si on veut un lissage des points (cf fonction S: lowess)
#         relatifs aux valeurs ajustees
# labels, title, figs, ask, ... :voir fonction 'pld'
#***************************************************************************

# Verification des arguments:
# --------------------------
if ( !missing(step) && ( (step <= 0) || (step > nls2.object$nb.steps)))
  stop(paste("\nThe requested step", 
               step, "and the effective number of steps", nls2.object$nb.steps,
               "does not match\n "))



# determination des divers elements constituant les donnees:
# --------------------------------------------------------
  data <- plsplitoutnls2(nls2.object)

z <- plsplitdnls2(data, nls2.object$response.name, nls2.object$X.names, labels=labels)
# On obtient:
# z$dmat:  matrice des va explicatives
# z$y: vecteur reponse,
# z$va.names: noms des variables explicatives
# z$response.name: nom du vecteur reponse,
# z$curve: noms des n indices indices de courbe
# z$labels: les labels sans ceux correspondant a des poids nuls

# Mise en dimension n des ajustes:
# --------------------------------

if ( !is.null(wanted$F.R) && wanted$F.R)
  {
    if (missing(step))
      {
        fittedf <-  fitted.nls2(nls2.object)$response
      }
  else
    {
      fittedf <-  nls2.object[[paste("step",step,sep="")]]$response
    }
    
  fittedf <- rep(fittedf, nls2.object$replications)
		  	
    if ( is.null(fittedf) || !is.numeric(fittedf)
        ||  is.null(nls2.object$replications))
      stop("The nls2.object should contain the fitted values of the response, and the vector of replications")
  } # fin F.R

if ( !is.null(wanted$V.R2) && wanted$V.R2)
  {
  if (missing(step))
    fittedv <-  fitted(nls2.object)$variance
  else
    fittedv <-  nls2.object[[paste("step",step,sep="")]]$variance

  fittedv <- rep(fittedv, nls2.object$replications)
  }


# Preparation des ordonnees:
ordlab <- "residuals"

if (st)
  {
  ordlab <- paste("standardized", ordlab)
  if (missing(step))
    residus <- residuals(nls2.object)$s.residuals
  else
    residus <-  nls2.object[[paste("step",step,sep="")]]$s.residuals
  }
else
  {
    if (missing(step))
    residus <- residuals(nls2.object)$residuals
  else
    residus <-  nls2.object[[paste("step",step,sep="")]]$residuals
  }
if (is.null(residus))
  stop("The nls2.object should contain the residuals")

n <- length(residus)
if (n != length(z$y))
  stop("\nThe 'nls2.object' and the data does not match\n")

if (absolute)
  {
  ordlabA <- paste("absolute", ordlab)
  residusA <- abs(residus)
  }


# Les identificateurs des points:
if (is.null(z$labels))
  z$labels <- rep("*", length(z$y))
else
  {
  if (length(z$labels) != length(z$y))
    stop("\n The length of the label vector does not match ")
  }

if (ask.modify)
  ask.pause <- T

# Appel des fonctions de traces graphiques:
# ----------------------------------------

# Sauvegarde des parametres "par" courants :
if (is.R()) oldpar<-par(no.readonly=T)
	else oldpar<-par()
	

# On efface les graphes precedents:
close.screen(all=TRUE)

# Argu qui ne servent pas ici:
xfit <- yfit <- curvefit <- NULL
		
if (!is.null(wanted$F.R) && wanted$F.R)
  {
  cat("\nPlots asked by the F.R option\n", fill=T)
  plnls2(as.matrix(fittedf), residus, z$labels,z$curve,
	 xfit, yfit, curvefit,
         title,
         "fitted values of the regression function",
         ordlab,
         jump=F,
         smooth=smooth,
         ask.pause, ask.modify,
          figs, ...)

  if (absolute)
    plnls2(as.matrix(fittedf), residusA, z$labels,z$curve,
	 xfit, yfit, curvefit,
         title,
         "fitted values of the regression function",
         ordlabA,
         jump=F,
         smooth=smooth,
         ask.pause, ask.modify,
          figs, ...)
  }

if (!is.null(wanted$R.R) && wanted$R.R)
  {
  cat("\nPlots asked by the R.R option\n", fill=T)
  plnls2(as.matrix(residus), residus,  z$labels,z$curve,
	 xfit, yfit, curvefit,
        title,
         paste("preceding",ordlab),
         ordlab,
	jump=T,
         smooth=smooth,
         ask.pause, ask.modify,
          figs, ...)
  }


if (!is.null(wanted$I.R) && wanted$I.R)
  {
  cat("\nPlots asked by the I.R option\n", fill=T)
  plnls2(as.matrix(1:n), residus, z$labels, z$curve,
	 xfit, yfit, curvefit,
         title,
         "residuals order",
         ordlab,
         jump=F,
         smooth=smooth,
         ask.pause, ask.modify,
         figs, ...)
  if(absolute)
    plnls2(as.matrix(1:n), residusA,z$labels, z$curve,
	 xfit, yfit, curvefit,
         title,
         "residuals order",
         ordlabA,
         jump=F,
         smooth=smooth,
         ask.pause, ask.modify,
         figs, ...)
  }

if (!is.null(wanted$X.R) && wanted$X.R)
  {
  cat("\nPlots asked by the X.R option\n", fill=T)
  plnls2(as.matrix(z$dmat), residus, z$labels, z$curve,
	 xfit, yfit, curvefit,
         title,
         z$va.names,
         ordlab,
         jump=F,
         smooth=smooth,
         ask.pause, ask.modify,
          figs, ...)
  if(absolute)
    plnls2(as.matrix(z$dmat), residusA,z$labels, z$curve,
	 xfit, yfit, curvefit,
         title,
         z$va.names,
         ordlabA,
         jump=F,
         smooth=smooth,
         ask.pause, ask.modify,
          figs, ...)
  }

if (!is.null(wanted$V.R2) && wanted$V.R2)
  {
  cat("\nPlots asked by the V.R2 option\n", fill=T)
  if (st)
    {
    cat("  cannot be asked with the 'st' option\n", fill=T)
    }
  else
    {
    plnls2(as.matrix(fittedv), (residus*residus), z$labels, z$curve,
	 xfit, yfit, curvefit,
         title,
         "fitted variance",
         ordlab,
         jump=F,
         smooth=smooth,
         ask.pause, ask.modify,
          figs, ...)
    }
  }

# on efface les graphes precedents:
#erase.screen(0) 
close.screen(all=TRUE)

# restitution des parametres de plotting originaux:
par(oldpar) 
invisible()
}


# : ### FICHIER plsplitnls2.s ###
plsplitdnls2<- function(data, response.name, X.names, labels)
{
# Determination des divers elements constituant les donnees
# --------------------------------------------------------
# Renvoie:
# dmat:  matrice des va explicatives
# response.name: nom du vecteur reponse
# y: vecteur reponse,
# va.names: noms des variables explicatives
# curve: noms des n indices indices de courbe
# labels: les labels correspondant a des poids non nuls

# Verification:
# ------------
if (!inherits(data,"data.frame"))
   stop("\nThe data must be in a 'data.frame'\n")

if (!is.character(response.name))
  stop("\nThe name of the response variable must be a character string\n")

if(is.na(match(response.name, names(data))))
  stop(paste("\nThe name of the response variable",
             response.name,
             "must be the name of a vector included in the 'data.frame'\n"))

lvar <- pmatch(X.names, names(data))
if (any(is.na(lvar)))
  stop(paste("\n The names of the vectors containing the independent variables",
  X.names,
  "must be the names of vectors included in the 'data.frame'\n"))


# Determination des divers elements constituant les donnees
# --------------------------------------------------------
dmat <- as.matrix(data)
y <-  dmat[,response.name]
mode(y) <- "numeric"

if (!is.null(data$weights))
  {
  # on enleve les donnees de poids nuls
  w <-  dmat[,"weights"]
  y <- y[w !=0]
  dmat <- dmat[w!=0,]
  if (length(labels) >0)
       labels <-  labels[w !=0]
  }

  
if (!is.null(data$curves))
  {
  curve <-  dmat[, "curves"]
  }
else
 curve <- NULL


dmat <-  as.matrix(dmat[, X.names])
dimnames(dmat) <- list(dimnames(dmat)[[1]], X.names)
mode(dmat) <-  "numeric"
z <- list(dmat=dmat, y=y, va.names=X.names,response.name=response.name,curve=curve, labels=labels)
return(z)
}

plsplitoutnls2 <- function(nls2.object)
{
# Recherche du data.frame associe au nls2.object
# quand celui-ci n'a pas ete sauvegarde dans celui-ci

data.name <-  as.character(nls2.object$call$data)

if (!exists(data.name))
  stop(paste("\nThe data.frame",
       data.name,
       "from which has been built the 'nls2.object' is not found\n"))
return(get(data.name))

}

  
# : ### FICHIER plvar.nls2.s ###
plvar <- function(x, ...)
  UseMethod("plvar")

plvar.default <- function(x,...)
  {
  if (!inherits(x,"nls2"))
    stop("This function is valid only on a 'nls2.object'")
  }

plvar.nls2<-function(nls2.object,
         step=nls2.object$nb.steps,
         fitted=F,
         wanted=list(X.S2=T, X.S=F, logX.logS2=F, Y.S2=T, Y.S=F, logY.logS2=F),
         smooth=F, n.fitted=0,
	 labels=NULL,
         title="",
         figs=c(2,2),ask.pause=T, ask.modify=F, ...)

{
#***************************************************************************
# FONCTION:
# representations graphiques en vue d'une etude de la variance empirique
#  (Y1) et/ou ajustee (Ajustes.VarY)
# relative a des donnees etudiees par nls2:
#
# ARGUMENTS:
# nls2.object: une sortie de la fonction nls2
# step: numero de l'etape (a partir de 1), en estimation alternee
# fitted: si on veut, sur les memes graphes que ceux ou est representee
#         la variance empirique, les variances ajustees
# X.S2: TRUE si on veut le graphe des variances
#      en fonction des variables explicatives
# X.S: TRUE si on veut le graphe des racines carrees des variances
#      en fonction des variables explicatives
# logX.logS2:  TRUE si on veut le graphe des logarithmes  des variances
#      en fonction des logarithmes  des variables explicatives
# Y.S2:  TRUE si on veut le graphe des variances
#      en fonction des moyennes empiriques (Y1)
#      si fitted, les variances ajustees sont representees
#      en fonction des esperances ajustees
# Y.S: TRUE si on veut le graphe des racines carrees des variances
#      en fonction des moyennes empiriques (Y1)
#      si fitted, les racines carrees des variances ajustees sont representees
#      en fonction des esperances ajustees
# logY.logS2: TRUE si on veut le graphe des logarithmes  des variances
#      en fonction des logarithmes  des moyennes empiriques (Y1)
#      si fitted, les logarithmes des variances ajustees sont representees
#      en fonction des logarithmes des esperances ajustees
#
# smooth: T si on veut un lissage des points (cf fonction S: lowess)
#         relatifs aux valeurs ajustees
# labels, title, figs, ask, ... :voir fonction 'pld'
#***************************************************************************
# Verification des arguments:
# --------------------------
if (is.null(nls2.object$replications))
  stop("The nls2.object should contain the component 'replications'")
if ( all(nls2.object$replications == 1))
  stop("\n This function is valid only when there are replications\n")

if ( !missing(step) && ( (step <= 0) || (step > nls2.object$nb.steps)))
  stop(paste("\nThe requested step",
               step, "and the effective number of steps", nls2.object$nb.steps,
               "does not match\n "))
if ( !is.numeric(n.fitted) || (n.fitted<0) ||
	( (n.fitted>0) &&  (n.fitted<2)))
  stop(paste(
"Argument 'n.fitted',", n.fitted,
"must be an integer greater than 2\n"))

	
# determination des divers elements constituant les donnees:
# --------------------------------------------------------
  data <- plsplitoutnls2(nls2.object)

if (is.null(nls2.object$data.stat))
  stop("The nls2.object should contain the component 'data.stat'")

if (length(labels) != length(nls2.object$data.stat$S2)) #labels non en dimension k
  z <- plsplitdnls2(data, nls2.object$response.name, nls2.object$X.names, labels=labels) 
else
  {
  # ne pas modifier les labels: ils sont en dim k
  z <- plsplitdnls2(data,nls2.object$response.name, nls2.object$X.names, labels=NULL)
  z$labels <- labels
  }


# On obtient:
# z$dmat:  matrice des va explicatives
# z$y: vecteur reponse,
# z$va.names: noms des variables explicatives
# z$response.name: nom du vecteur reponse,
# z$curve: noms des n indices de courbe
# z$labels: les labels sans ceux correspondant a des poids nuls

# Verif quand on demande la generation de nouveaux points de calcul:	
if (n.fitted>0)
  fitted  <-  T

if  (n.fitted>0)
  {	
  if (ncol(z$dmat)>1)
    {
    warning(paste(
	"Option 'n.fitted' ignored because there are several independent variables.\n",
	"Fitted values of the data are considered instead.\n"))
    n.fitted <- 0
    }
  if (nls2.object$model$vari.type=="VI")
    {
    warning(paste(
	"Option 'n.fitted' ignored because the variance is the intra-replications variance.\n",
	"Fitted values of the data are considered instead.\n"))
    n.fitted <- 0
    }
  } # fin (n.fitted>0)
	
					
# Mise en dimension k des variables explicatives:
# ----------------------------------------------
indices <-  cumsum(nls2.object$replications)
if (length(indices) != length(nls2.object$data.stat$S2))
  stop("\nThe 'nls2.object' and the data does not match\n ")

if (length(z$labels) == length(z$y)) 
  {
  z$labels <-  z$labels[indices]
  }

z$dmat <-  matrix(z$dmat[indices,],ncol=length(z$va.names))
z$y <-  z$y[indices]
if (!is.null(data$curve))
  z$curve <- z$curve[indices]


# Les identificateurs des points:
if (is.null(z$labels))
  z$labels <- rep("*", length(z$y))
else
  {
  if (length(z$labels) != length(z$y))
    stop("\n The length of the label vector does not match \n")
  }


# Constitution des abscisses et ordonnees:
# --------------------------------------
# Les valeurs observees  qui seront eventuellement lissees
# par une ligne pointillee, les ajustees seront toujours lissees
# par une ligne pleine
xfit <- yfit <- varfit <- curvefit <- logxfit <- logvarfit <- logyfit <- NULL
	
S2 <- nls2.object$data.stat$S2
S2lab <- "empirical variance"

if (fitted)
  {
  if (missing(step))
    {	
    if (n.fitted==0)
      {
      varfit <-  fitted(nls2.object)$variance
      if (is.null(varfit))
        stop("The nls2.object should contain the fitted values of the variance")
      } # fin if (n.fitted==0)
    else
      {
      # Pour le calcul de la variance sur une grille
      theta <- coef(nls2.object)$theta
      beta <-  coef(nls2.object)$beta		
      sigma2 <- coef(nls2.object)$sigma2
      if ( is.null(theta) || is.null(sigma2))
        stop("The nls2.object should contain the estimated values of the parameters and  sigma2")            
      }
    }	# fin de pas d'etape
  else
    {
    if (n.fitted==0)
      {
      varfit <-  nls2.object[[paste("etape",step,sep="")]]$variance
      if (is.null(varfit))
        stop("The nls2.object should contain the fitted values of the variance")
    }# fin if (n.fitted==0)
    else
      {
      # Pour le calcul de la variance sur une grille
      theta <- nls2.object[[paste("step",step,sep="")]]$theta
      beta <- nls2.object[[paste("step",step,sep="")]]$beta
      sigma2 <- nls2.object[[paste("step",step,sep="")]]$sigma2		
      if ( is.null(theta) || is.null(sigma2))
        stop("The nls2.object should contain the estimated values of the parameters and  sigma2")            
      }			
    }	# fin de il y a des steps

  S2lab <- paste("fitted and", S2lab)
  if (n.fitted >1)
    {
    # calc.f=T, si il faut garder les f	
    calc.f <-  ( (!is.null(wanted$Y.S2) && wanted$Y.S2)
   || (!is.null(wanted$Y.S) && wanted$Y.S)
   || (!is.null(wanted$logY.logS2) && wanted$logY.logS2))
    # Generer xfit et curvefit
    # calculer varfit=v(theta,beta)*sigma2 (poids supposes 1 sur la grille)
    # et, si calc.f, yfit
    RetFit <-  cfitnls2(nls2.object,z, n.fitted,
	theta, beta, sigma2, calc.f, calc.v=T)
    xfit <- as.matrix(RetFit$xfit)			
    curvefit <- RetFit$curvefit			
    yfit <- as.matrix(RetFit$yfit)
    varfit <- RetFit$varfit	
    } # fin de (n.fitted >0)
  else
    {
    xfit <- as.matrix(z$dmat)
    curvefit <- z$curve
    }	
  } # fin de fitted

if ( (!is.null(wanted$Y.S2) && wanted$Y.S2)
   || (!is.null(wanted$Y.S) && wanted$Y.S)
   || (!is.null(wanted$logY.logS2) && wanted$logY.logS2)
   )
  {
  Y1 <-  nls2.object$data.stat$Y1
  Y1lab <- "empirical means"
  if (fitted)
    {
    if (missing(step))
      {	
      if (n.fitted==0)      	
        yfit <-  as.matrix(fitted(nls2.object)$response)
      }					
    else
      {
      if (n.fitted==0)  		
        yfit <-  as.matrix(nls2.object[[paste("etape",step,sep="")]]$response)
      }
    if (is.null(yfit) || (!is.numeric(yfit)) )
      stop("The nls2.object should contain the fitted values of the response")
    Y1lab <- paste("fitted and", Y1lab)
    }
  }

		
# Verification des Log:
# --------------------
if (!is.null(wanted$logX.logS2) && wanted$logX.logS2)
  {
  if (any(z$dmat<=0))
    {
    warning(paste(
 "The plot of the logarithm cannot be made:\n",
 "numerical error when calculating the log of the independent variables\n"))
    wanted$logX.logS2  <- F
    }
  logx <- log(z$dmat)
  if (n.fitted>0)
    {	
    if (any(xfit<=0))
      {
      warning(paste(
 "The plot of the logarithm cannot be made:\n",
 "numerical error when calculating the log on the generated values of the independent variables\n"))
      wanted$logX.logS2  <- F
      }
    logxfit <- as.matrix(log(xfit))
    } # fin de (n.fitted>0)	
  } # fin de wanted$logX.logS2

if ( (!is.null(wanted$logX.logS2) && wanted$logX.logS2)
   || (!is.null(wanted$logY.logS2) && wanted$logY.logS2))
  {    
  if (any(S2<=0))
      {
      warning(paste(
	"The plot of the logarithm cannot be made:\n",
	"numerical error on the empirical variances\n"))
      wanted$logX.logS2  <- F
      wanted$logY.logS2 <- F
      }
  logS2 <- log(S2)
  if (fitted)
    {
    if (any(varfit<=0))
      {
      warning(paste(
	"The plot of the logarithm cannot be made:\n",
	"numerical error on the fitted variances\n"))
      wanted$logX.logS2  <- F
      wanted$logY.logS2 <- F
      }
    logvarfit <- log(varfit)
    }	
  }


if ( !is.null(wanted$logY.logS2) && wanted$logY.logS2)
  {
  if (any(Y1<=0))
    {
    warning(paste(
	"The plot of the logarithm cannot be made:\n",
	"numerical error on the empirical means\n"))
    wanted$logY.logS2 <- F
    }
  logY1 <- log(Y1)
  if (fitted)
    {
    if (any(yfit<=0))
      {
      warning(paste(
	"The plot of the logarithm cannot be made:\n",
	"numerical error on the fitted responses\n"))
      wanted$logY.logS2 <- F
      }
    logyfit <- as.matrix(log(yfit))
    }	
  }

	
# Fin verification des log
# -----------------------

# Pour que R ne mette pas d'erreur si varfit est nul:
if (is.null(varfit))
  sqrtvarfit  <-  NULL
else
  sqrtvarfit  <-  sqrt(varfit)

if (ask.modify)
  ask.pause <- T

# Appel des fonctions de traces graphiques:
# ----------------------------------------

# Sauvegarde des parametres "par" courants :
if (is.R()) oldpar<-par(no.readonly=T)
	else oldpar<-par()

# On efface les graphes precedents:
close.screen(all=TRUE)

if (!is.null(wanted$X.S2) && wanted$X.S2)
  {
  cat("\nPlots asked by the X.S2 option\n", fill=T)
	
  plnls2(as.matrix(z$dmat),S2, z$labels, z$curve,
	 xfit, varfit,  curvefit,
	  title, 
	  xlab=z$va.names, ylab=S2lab, 
          jump=F,
         smooth=smooth,
         ask.pause, ask.modify,
         figs, ...)
  }
# pour pas que S confonde X.S2 avec X.S:
wanted$X.S2 <- NULL

if (!is.null(wanted$logX.logS2) && wanted$logX.logS2)
  {
  cat("\nPlots asked by the logX.logS2 option\n", fill=T)
  plnls2(as.matrix(logx), logS2, z$labels, z$curve,
	 logxfit, logvarfit, curvefit,
         title,
	 xlab=paste("log of",z$va.names),ylab=paste("log of",S2lab),
         jump=F, smooth=smooth, ask.pause, ask.modify, figs, ...)
  }


if (!is.null(wanted$X.S) && wanted$X.S)
  {
  cat("\nPlots asked by the X.S option\n", fill=T)
  plnls2(as.matrix(z$dmat), sqrt(S2), z$labels, z$curve,
	 xfit, sqrtvarfit, curvefit,
         title,
	 xlab=z$va.names,ylab=paste("sqrt of",S2lab),
         jump=F, smooth=smooth, ask.pause, ask.modify, figs, ...)
  }

if (!is.null(wanted$Y.S2) && wanted$Y.S2)
  {
  cat("\nPlots asked by the Y.S2 option\n", fill=T)
  plnls2(as.matrix(Y1), S2, z$labels, z$curve,
	 yfit, varfit, curvefit,
         title,
	 xlab=Y1lab,ylab=S2lab,
	 jump=F, smooth=smooth, ask.pause, ask.modify, figs, ...)
  }
wanted$Y.S2 <- NULL

if (!is.null(wanted$Y.S) && wanted$Y.S)
  {
  cat("\nPlots asked by the Y.S option\n", fill=T)
  plnls2(as.matrix(Y1), sqrt(S2), z$labels, z$curve,
	 yfit, sqrtvarfit, curvefit,
         title,
	 xlab=Y1lab,ylab=paste("sqrt of",S2lab),
         jump=F, smooth=smooth, ask.pause, ask.modify, figs, ...)
  }

if (!is.null(wanted$logY.logS2) && wanted$logY.logS2)
  {
  cat("\nPlots asked by the logY.logS2 option\n", fill=T)
  plnls2(as.matrix(logY1), logS2,  z$labels, z$curve,
	 logyfit, logvarfit, curvefit,
         title,
         xlab=paste("log of",Y1lab),ylab=paste("log of",Y1lab),
        jump=F, smooth=smooth, ask.pause, ask.modify, figs, ...)
  }

# on efface les graphes precedents:
#erase.screen(0) 
close.screen(all=TRUE)

# restitution des parametres de plotting originaux:
par(oldpar) 
invisible()
}
# : ### FICHIER print.coef.nls2.s ###
print.coef.nls2<-
function(object, ...)
{
# ecrire un coef.nls2.object
  mat <- NULL
  if (!is.null(object$theta))
    {
        mat <- matrix(object$theta, ncol=1)
        noms <- names(object$theta)
        if (!is.null(object$beta) &&
            !all(is.na(object$beta)))
          {
          mat <- rbind(mat, matrix(object$beta,ncol=1))
          noms <- c(noms, names(object$beta))
          }
      } # fin if (!is.null(object$theta))
  if (!is.null(object$std.error) && (!is.null(mat)) )
    {
        if (!all(is.na(object$std.error))) 
          {
        mat <- cbind(mat, object$std.error)
          t.value <-  mat[,1]/mat[,2]
          mat <- cbind(mat, t.value)
          dimnames(mat) <- list(noms, c("Value","Std. Error","t value"))
          }
        else
          {
          dimnames(mat) <- list(noms, c("Value"))
         }
        
      } # fin  if (!is.null(object$std.error))
  if (!is.null(object$theta) || !is.null(object$std.error))
    {
        print(mat,...)
      }
  else
  warning("No fitting values of the parameters or std.error in the nls2.object")
  
invisible()

}
# : ### FICHIER print.fitted.nls2.s ###
print.fitted.nls2<-
function(fitted.nls2.object, ...)
{
# ecrire un fitted.nls2.object
if(!is.null(fitted.nls2.object$response))
  {
  cat("\n response:\n", fill=T)
  print(fitted.nls2.object$response)
  }
if(!is.null(fitted.nls2.object$variance))
  {
  cat("\n variance:\n", fill=T)
  print(fitted.nls2.object$variance)
  }
if(!is.null(fitted.nls2.object$FOdes))
  {
  cat("\n FOdes:\n", fill=T)
  print(fitted.nls2.object$FOdes)
  }

invisible()

}
# : ### FICHIER print.nls2.s ###
prstepnls2<-function(nls2.step)
{
# fonction d'impression d'une etape d'un nls2.object

cat(nls2.step$message,  fill=T)
if (!is.null(nls2.step$stop.crit))
  cat(" stopping criterion:", nls2.step$stop.crit,  fill=T)
if (!is.null(nls2.step$stat.crit))
  cat(" statistical criterion:", nls2.step$stat.crit,  fill=T)
if (!is.null(nls2.step$nb.iters))
  cat(" number of iterations:",nls2.step$nb.iters,  fill=T)

if (!is.null(nls2.step$theta))
  {
    cat(" parameters estimations:", fill=T)
    print(nls2.step$theta)
    if ( !is.null(nls2.step$beta) && !all(is.na(nls2.step$beta)))
  {
  cat(" variance parameters estimations:", fill=T)
  print(nls2.step$beta)
  }
  } # fin if (!is.null(nls2.step$theta))

if (!is.null(nls2.step$std.error) && !all(is.na(nls2.step$std.error)))
  {
  cat(" parameters standard errors:", fill=T)
  print(nls2.step$std.error)
  }
}


print.nls2<-
function(nls2.object,digits = NULL, ...)
{

# fonction d'impression d'un nls2.object

if(!missing(digits)) 
  {
  if((length(digits) != 1 || digits < 1) || digits > 20)
          stop("Bad value for digits argument")
  d <- options(digits = digits)
  on.exit(options(d))
  }

if (!is.null(nls2.object$replications))
  {
cat("\nNumber of distinct observations:", length(nls2.object$replications), fill=T)

cat("Total number of replications:", sum(nls2.object$replications), fill=T)
} # fin if (!is.null(nls2.object$replications))
 
if (nls2.object$nb.steps ==1)
  {
  prstepnls2(nls2.object)
  }
else
  {
  for (i in (1:nls2.object$nb.steps))
    {
    cat("\nStep", i,":	\n------", fill=T)
    switch(i,
      prstepnls2(nls2.object$step1),
      prstepnls2(nls2.object$step2),
      prstepnls2(nls2.object$step3)
          )
     }
  }


}
# : ### FICHIER print.residuals.nls2.s ###
print.residuals.nls2<-
function(residuals.nls2.object, ...)
{
# ecrire un residuals.nls2 object

if (!is.null(residuals.nls2.object$residuals))
  {
  cat("\nresiduals:\n",  fill=T)
  print(residuals.nls2.object$residuals)
  }

if (!is.null(residuals.nls2.object$s.residuals))
  {
  cat("\nstandardized residuals:\n",  fill=T)
  print(residuals.nls2.object$s.residuals)
  }
invisible()

}
# : ### FICHIER print.summary.nls2.s ###

prsummarystepnls2 <- function(algorithm, summary.step)
{
#
# fonction d'impression d'une etape d'un summary.nls2.object
#

        cat(" method:", summary.step$method, fill=T)
        if (!is.null(summary.step$stat.crit.type))
        cat(" statistical criterion type:", summary.step$stat.crit.type, fill=T)
        if (!is.null(summary.step$nb.iters))
	cat(" number of iterations:", summary.step$nb.iters,  fill=T)
        if (!is.null(summary.step$stop.crit))
        cat(" stopping criterion:", summary.step$stop.crit,  fill=T)
        if (!is.null(summary.step$stat.crit))
        cat(" statistical criterion:", summary.step$stat.crit,  fill=T)
        if (!is.null(summary.step$lambda) && (algorithm == "GM"))
          cat(" Gauss-Marquardt algorithm parameter:", summary.step$lambda,  fill=T)
        if (!is.null(summary.step$sigma2))
        cat(" sigma**2:",summary.step$sigma2,  fill=T)
	if (!is.null(summary.step$deviance))
	cat(" deviance:	", summary.step$deviance, fill=T)
        if (!is.null(summary.step$rss))
        cat(" sum of squares:", summary.step$rss,  fill=T)
        if ( !is.null(summary.step$rss.unweighted) && !is.na(summary.step$rss.unweighted))
          cat(" unweighted sum of squares:", summary.step$rss.unweighted,  fill=T)

        print.coef.nls2(summary.step)
        cat( summary.step$message, "\n\n", fill=T)
}


print.summary.nls2<-
function(summary.nls2.object,digits = NULL, ...)
{
#
# fonction d'impression d'un summary.nls2.object
#
        if(!missing(digits)) {
                if((length(digits) != 1 || digits < 1) || digits > 20)
                        stop("Bad value for digits argument")
                d <- options(digits = digits)
                on.exit(options(d))
        }
if (!is.null(summary.nls2.object$k))
          cat(" number of distinct observations:", summary.nls2.object$k,  fill=T)

if (!is.null(summary.nls2.object$n))
        cat(" total number of replications:", summary.nls2.object$n, fill=T)
if (!is.null(summary.nls2.object$algorithm))
        cat(" algorithm:", summary.nls2.object$algorithm, fill=T)
if (!is.null(summary.nls2.object$sigma2.type))
        cat(" sigma type:", summary.nls2.object$sigma2.type, fill=T)
if (!is.null(summary.nls2.object$vari.type))
        cat(" variance type:", summary.nls2.object$vari.type, fill=T)
if (!is.null(summary.nls2.object$family))
	cat(" family:", summary.nls2.object$family, fill=T)
	
if (is.null(summary.nls2.object$step1))
  {
  prsummarystepnls2(summary.nls2.object$algorithm,summary.nls2.object)
  }
else
  {
  cat("\nStep 1:	 \n------\n")
  prsummarystepnls2(summary.nls2.object$algorithm,summary.nls2.object$step1)
  if (!is.null(summary.nls2.object$step2))
    {
      cat("Step 2:	 \n------\n")
      prsummarystepnls2(summary.nls2.object$algorithm,summary.nls2.object$step2)
    }
   if (!is.null(summary.nls2.object$step3))
    {
    cat("Step 3:	 \n------\n")
    prsummarystepnls2(summary.nls2.object$algorithm,summary.nls2.object$step3)
    }
  }
}
# : ### FICHIER residuals.nls2.s ###
residuals.nls2<-
function(nls2.object)
{
# extraire les residus et residus reduits d'un nls2.object

residuals.object  <-  list(call=match.call())
class(residuals.object) <- "residuals.nls2"

if ( !is.null(nls2.object$step3$residuals))
  {
  residuals.object$residuals <- nls2.object$step3$residuals
  residuals.object$s.residuals <- nls2.object$step3$s.residuals
  }
else
  {
   #step3 null
    
if (!is.null(nls2.object$step2$residuals))
  {
  residuals.object$residuals <- nls2.object$step2$residuals
  residuals.object$s.residuals <- nls2.object$step2$s.residuals
  }

else
  {
    # step3 null et step2 null
   if (!is.null(nls2.object$step1$residuals))
  {
  residuals.object$residuals <- nls2.object$step1$residuals
  residuals.object$s.residuals <- nls2.object$step1$s.residuals
  }
   else
     {
       # step3 null et step2 null et step1 null
residuals.object$residuals <- nls2.object$residuals
residuals.object$s.residuals <- nls2.object$s.residuals
}}
}
return(residuals.object)

}

# : ### FICHIER summary.nls2.s ###

summarystepnls2 <- function(object)
{
#  Extraire les resultats principaux d'une etape  d'un nls2.object

sumy <- list(  message=object$message, 
               method=object$method, 
		stat.crit.type=object$stat.crit.type,
               nb.iters=object$nb.iters, stop.crit=object$stop.crit, 
               stat.crit=object$stat.crit,
	       deviance=object$deviance,
               lambda=object$lambda, sigma2=object$sigma2, 
               rss=object$rss, rss.unweighted=object$rss.unweighted,
               theta=object$theta, beta=object$beta)
	if ( !is.null(object$as.var) && !all(is.na(object$as.var)))
  {
  sumy$std.error <-sqrt(diag(object$as.var))
  names(sumy$std.error) <-  dimnames(object$as.var)[[1]]
  }
for (comp in names(sumy))
        {
        if (is.null(sumy[[comp]])) sumy[[comp]] <- NULL
       }

return(sumy)
invisible()
}


summary.nls2<-function(nls2.object)
{
#  Extraire les resultats principaux d'un nls2.object

  sumy <- list(
               algorithm=nls2.object$stat.ctx$algorithm,
               sigma2.type=nls2.object$stat.ctx$sigma2.type,
               vari.type=nls2.object$model$vari.type, 
               message=nls2.object$message, 
               method=nls2.object$method, family=nls2.object$stat.ctx$family,
		stat.crit.type=nls2.object$stat.crit.type,
               nb.iters=nls2.object$nb.iters, stop.crit=nls2.object$stop.crit, 
               stat.crit=nls2.object$stat.crit,
               lambda=nls2.object$lambda, sigma2=nls2.object$sigma2,
	       deviance=nls2.object$deviance,
               rss=nls2.object$rss, rss.unweighted=nls2.object$rss.unweighted,
               theta=nls2.object$theta, 
               beta=nls2.object$beta)


               if (!is.null(nls2.object$replications))
    {
      sumy$k  <-  length(nls2.object$replications)

      sumy$n  <-  sum(nls2.object$replications)
    }
  

 class(sumy) <- "summary.nls2"

if (nls2.object$nb.steps ==1)
  {
  if (!is.null(nls2.object$as.var) &&  !all(is.na(nls2.object$as.var)))
    {
    sumy$std.error <-sqrt(diag(nls2.object$as.var))
    names(sumy$std.error) <-  dimnames(nls2.object$as.var)[[1]]
    }
  }
else
  {
  for (i in (1:nls2.object$nb.steps))
    {
    switch(i,
      sumy[["step1"]] <- summarystepnls2(nls2.object$step1),
      sumy[["step2"]] <- summarystepnls2(nls2.object$step2),
      sumy[["step3"]] <- summarystepnls2(nls2.object$step3)
          )
     }
} # fin pls etapes
# On enleve les composants nuls
for (comp in names(sumy))
        {
        if (is.null(sumy[[comp]])) sumy[[comp]] <- NULL
       }
  
sumy
}
