//--------------- Carte.cc ----------------



#include <stdlib.h>
#include <iostream.h>
#include <math.h>
#include <string.h>
#include <fstream.h>
#include "Carte.h"

extern int french;


//---------------------------CONSTRUCTEUR--------------------------------------


Carte::Carte(void)
{

  //------------------initialisation des variables d'interet------------------

  NbIle = -1;        //Nombre d'iles.
  LgIle = 0;         //Longueur moyenne des iles.
  LgIleTotale = 0;   //Longueur totale des iles.
  Ocean = 0;         //Proportion d'ocean.
  VarNbIle =0;       //Variance du nombre d'iles.
  VarLgIle =0;       //Variance de la longueur moyenne des iles.
  VarOcean =0;       //Variance de la proportion d'ocean.
  
}



//-------------INITIALISATION DU TABLEAU ET DES VARIABLES MOYENNES------------


void Carte :: init(double *p, int SIZE)

  //p : tableau regroupant les valeurs NbIle, LgIle et Ocean pour chaque iteration.
  //SIZE :Nombre d'iterations.

{


  //-----------------------Variables locales---------------------------------- 
  int i,  //compteur de boucle.
    j;  //compteur de boucle.

  //----------------------Initialisation du tableau regroupant les valeurs de NbIle, LgIle et Ocean pour chaque iteration.------------------------

  for (i=0;i<3;i++)
    for (j=0;j<SIZE;j++)
      *(p+i+j*3)=0;
  
  //-------------------Initialisation des variables moyennes-------------------

  NbMoy = 0;             // Nombre moyen d'iles.
  LgMoy = 0;             // Longueur moyenne des iles. 
  OceanMoy =0;           // Proportion moyenne des oceans.
}




//-----------------MISE A JOUR A CHAQUE DEBUT D'UNE NOUVELLE ILE---------------
 

void Carte :: maj(double DebIlePred, double DebIle, double FinIle )

  //DebIlepred : position de debut d'ile precedente.
  //DebIle : position de debut d'ile courante.
  //FinIle : position de fin d'ile courante.

{
  //----------Mise a jour de la proportion d'ocean, si les iles ne se------------------------ chevauchent pas-------------------------------------------------

  if (DebIlePred > FinIle)  Ocean += DebIlePred - FinIle;

  //----------Mise a jour des longueurs moyennes des iles---------------------
  LgIle = FinIle - DebIle;
  LgIleTotale += LgIle;
  
   //----------Mise a jour du nombre d'iles------------------------------------
  NbIle++;
  
}




//-----------------MISE A JOUR FINALE POUR UNE ITERATION-----------------------



//-------------Cas ou l'on ne met pas les valeurs dans un fichier--------------

void Carte :: majfin(double *DebIle, double *FinIle, double *DebIlePred,double G, int n, double *p, double max, int SIZE)

  //DebIlepred : position de debut d'ile precedente.
  //DebIle : position de debut d'ile courante.
  //FinIle : position de fin d'ile courante.
  //G : longueur de la sequence normalisee.
  //n : nombre d'iterations.
  //p : tableau regroupant les valeurs NbIle, LgIle, Ocean et Lgvarintra pour caque iteration.
  //max : longueur non normalisee d'un long clone.
  //SIZE : Nombre d'iterations.
 
{

  //----------------initialisation du tableau a la premiere iteration----------

  if (n==0) init(p, SIZE);

  //-------remplissage du tableau & comptabilisation des valeurs moyennes------

  remplitab(p, n, max, *DebIle, G, *DebIlePred);

  //---------------reinitialisation de DebIle, FinIle, DebIlePred--------------

  reinit(DebIle, FinIle, DebIlePred, G);

}




//-----------------Cas ou l'on met les valeurs dans un fichier-----------------


void Carte :: majfin(double *DebIle, double *FinIle, double *DebIlePred,double G, int n, double *p, double max, ofstream& ofic, int SIZE)

  //DebIlepred : position de debut d'ile precedente.
  //DebIle : position de debut d'ile courante.
  //FinIle : position de fin d'ile courante.
  //G : longueur de la sequence normalisee.
  //n : nombre d'iterations.
  //p : tableau regroupant les valeurs NbIle, LgIle, Ocean et Lgvarintra pour caque iteration.
  //max : longueur non normalisee d'un long clone.
  //ofic : fichier optionnel regroupant les valeurs NbIle, LgIle, Ocean et Lgvarintra pour caque iteration.
  //SIZE : Nombre d'iterations.
 
{
  //---------------mise a jour finale a chaque iteration-----------------------

  majfin(DebIle, FinIle, DebIlePred, G, n, p, max, SIZE);

  //---------------ecriture dans un fichier des valeurs des variables----------

  ecritfichier(ofic);
}




//-------------------REMPLISSAGE DU TABLEAU DE VALEURS-------------------------
//-----------------COMPTABILISATION DES VALEURS MOYENNES-----------------------


void Carte :: remplitab(double *p, int n, double max, double DebIle, double G, double DebIlePred)

  //p : tableau regroupant les valeurs NbIle, LgIle, Ocean et Lgvarintra pour caque iteration.
  //n : nombre d'iterations.
  //max : longueur non normalisee d'un long clone.
  //DebIlepred : position de debut d'ile precedente.
  //DebIle : position de debut d'ile courante.
  //G : longueur de la sequence normalisee.

{
  //-------------------remplissage du tableau de valeurs-----------------------
  
  //------------Ecriture de la valeur de NbIle dans le tableau-----------------
  *(p+n*3)=  NbIle;
    
  //------------Calcul et ecriture de la valeur de LgIleTotale dans le tableau-
  // AB: 15/06/98: rajout du test suivant
  if (NbIle>0) 
  {
    LgIleTotale /= NbIle;
    LgIleTotale *= max;
  }

  *(p+1+n*3) = LgIleTotale;

 //------------Calcul et ecriture de la valeur de Ocean dans le tableau-------
  Ocean += DebIle;

  Ocean = Ocean / G ;
  *(p+2+n*3) = Ocean;

  //-----------------comptabilisation des valeurs moyennes---------------------
  
  NbMoy += NbIle;
  LgMoy += LgIleTotale; 
  OceanMoy += Ocean;
}




//-----------REINITIALISATION DES VARIABLES DebIle, FinIle, debIlePred---------


void Carte :: reinit(double *DebIle, double *FinIle, double *DebIlePred, double G)

  //DebIlepred : position de debut d'ile precedente.
  //DebIle : position de debut d'ile courante.
  //FinIle : position de fin d'ile courante.

{
  *DebIle = G;
  *FinIle = G;
  *DebIlePred = G;

}




//-----------ECRITURE DES VALEURS DES VARIABLES DANS UN FICHIER----------------


void Carte :: ecritfichier(ofstream& ofic)

//ofic : fichier optionnel regroupant les valeurs NbIle, LgIle, Ocean et Lgvarintra pour chaque iteration.

{
  ofic<<NbIle<<"   "<<LgIleTotale<<"   "<<Ocean<<endl;
}




//---------------ALLONGEMENT OU COMMENCEMENT D'UNE ILE-------------------------


void Carte :: allongile(double *FinIle, double *DebIle, double *DebIlePred, double posfinclone, double posdebclone, int *Ile, double G)

  //DebIlepred : position de debut d'ile precedente.
  //DebIle : position de debut d'ile courante.
  //FinIle : position de fin d'ile courante.
  //posfinclone : position de fin de clone courant.
  //posdebclone : position de debut de clone courant.
  //Ile : indicateur de commencement ou d'allongement d'iles.
  //G : longueur normalisee de la sequence.

{
  //--------------------commencement d'une ile---------------------------------

  if (*Ile == 0)
    {
      //--------Mise a jour des variables d'interet--------------------------- 
      maj(*DebIlePred, *DebIle, *FinIle);

      //--------Mise a jour des variables DebIle, FinIle et DebIlePred--------
      *DebIlePred = *DebIle;
      *DebIle = G;
      *FinIle = posfinclone;   

      //--------Ile = 1 signifie qu'une ile est commencee---------------------
      *Ile = 1;
    
    }// fin de alors.  

  //--------------------allongement d'une ile = mise a jour DebIle ------------
  
  if (*DebIle>posdebclone) *DebIle = posdebclone;

}




//-------------------CALCUL DE LA MOYENNE ET LA VARIANCE-----------------------

 
void Carte :: variance(double *varstat,double *p,double *stat, int SIZE)

  //varstat : variance de la quantite d'interet.
  //p : tableau regroupant les valeurs NbIle, LgIle, Ocean et Lgvarintra pour caque iteration. 
  //stat : moyenne de la quantite d'interet.
  //unite : unite de la quantite d'interet.
  
{
  //------------------Variables locales----------------------------------------
  int i;              // compteur de boucle.
  //---------------------------calcul de la moyenne---------------------------
      
  *stat = *stat/SIZE;
   
  //---------------------------calcul de la variance--------------------------

  for (i=0;i<SIZE;i++) 
       *varstat += ((*(p+i*3)-*stat) * (*(p+i*3)-*stat)) ;
  
  if (SIZE > 1) // cas ou plusieurs simulations
    *varstat = *varstat/(SIZE-1);

}


//---------------------CALCULS STATISTIQUES (MOYENNES - VARIANCES)-------------


void Carte :: statistiques(double *p, int SIZE)
  
  //p : tableau regroupant les valeurs NbIle, LgIle, Ocean et Lgvarintra pour caque iteration.
  //SIZE : Nombre d'iterations.

{  
  //--------------------------initialise NbIle a 0----------------------------
  
  NbIle++;
  
  //----------------calcul moyenne et variance du nombre d'iles---------------
  
  variance(&VarNbIle, p, &NbMoy, SIZE);

  //----------------calcul moyenne et variance de la longueur des iles--------

  variance(&VarLgIle, p+1, &LgMoy, SIZE);  


   //----------------calcul moyenne et variance d'ocean------------------------

  variance(&VarOcean, p+2, &OceanMoy, SIZE);  


  cout<<endl;
}
   
//---------------------RENVOIE LES MOYENNES -----------------------------------
void Carte ::  getmoy(double& nb, double& lg, double& oc)
{
nb= this->NbMoy ;
lg= this->LgMoy ;
oc= this->OceanMoy ;
}

//---------------------RENVOIE LES VARIANCES---------------------------------
void Carte :: getvar(double& nb, double& lg, double& oc)
{
nb= this->VarNbIle ; 
lg= this->VarLgIle ;
oc= this->VarOcean ;

}







































