//---------------------- Carte.h ---------------------

#ifndef CLASS_CARTE
#define CLASS_CARTE
#include <fstream.h>

class Carte {

       
  double NbIle,            //compteur d'iles.
         LgIleTotale,      // longueur totale des iles puis longueur 
                           //moyenne d'ile pour une iteration.
         LgIle,            //longueur de l'ile courante.
         Ocean,            //pourcentage d'ocean.
         NbMoy,            //Nombre moyen d'iles.
         LgMoy,            //Longueur moyenne des iles.
         OceanMoy,         //pourcentage moyen des oceans.
         VarLgIle,         //variance de la longueur moyenne.
         VarNbIle,         //variance du nombre d'iles.
         VarOcean;         //variance du pourcentage d'ocean.
         

public : 
         //constructeur.
         Carte();     
       
         //initialisation du tableau de valeurs. 
         void init(double*, int);
       
         //remplissage du tableau.
         void remplitab(double* , int, double, double, double, double);
       
         //reinitialisation des variables Debile, FinIle, DebIlePred.
         void reinit(double*,double*,double*, double);
       
         //mise a jour.
         void maj(double, double, double);
      
         //mise a jour finale pour une iteration 
         //(cas ou on ne met pas les valeurs dans un fichier. 
         void majfin(double*, double*,double*,double,int,double*,double, int);
        
         //mise a jour finale pour une iteration
         //cas ou on met les valeurs dans un fichier. 
         void majfin(double*, double*,double*,double,int,double*,double,ofstream&, int);
         //ecriture dans le fichier. 
         void ecritfichier(ofstream&);

         //allongement ou commencement d'une ile.
         void allongile(double*, double*, double* ,double, double, int*, double);
       
         //calcul de la moyenne et de la variance. 
         void variance(double*,double*,double*, int);

         //statistiques(moyennes et variances).
         void statistiques(double*, int);

	 //renvoie les moyennes
        void getmoy(double& NbMoy, double& LgMoy, double& OceanMoy);

	 //renvoie les variances
        void getvar(double& VarLgIle, double& VarNbIle, double& VarOcean);
};
#endif

