//------------------ Clone.cc -----------------


#include <iostream.h>
#include "Clone.h"

extern int french;


//-------------------------CONSTRUCTEUR----------------------------------------


Clone :: Clone(double N) 
{ 
  Nmoyen = N;
}


//-----------------------LECTURE DES POSITIONS-------------------------------
// le fichier est suppos tri par valeur dcroissante des positions de fin
// celles-ci sont non normalises


 double Clone::litclone(ifstream& ific, double  & posfinclone, 
                             double Ginit, double max) 
{

//--------------------declaration des fonctions appelees-------------------
extern int lit_com(ifstream& ific, double & valeur);

double posdebclone;

// Cas fin de fichier:
if ( lit_com(ific,posdebclone ) <0)
    {
	posdebclone=posfinclone = -1 ;
	return(posdebclone);
      }

if ( (posdebclone> Ginit) || (posdebclone <= 0))
	       {
		 if (french==1)
		   cerr << endl
			<< "Erreur sur le fichier des clones :"
			<< endl
			<< "Un clone commence en position " 
			<< posdebclone 
			<< endl
			<< "Il dborde du gnome [1,"
			<< Ginit << "]. " << endl ;
                 else
		   cerr << endl
			<< "Error on the clone file:"
			<< endl
			<< "One clone begins at location  " 
			<< posdebclone 
			<< endl
			<< "It is then not strictly contained in the genome [1,"
			<< Ginit << "]. " << endl ;
                 exit(1);
	       }

// Cas ou on lit un debut mais pas de fin de clone:
if ( lit_com(ific,posfinclone ) <0)
      {
      if (french==1)
	   cerr << endl
		<<"Fin prmature du fichier des clones :"  << endl
		<< "la position de la fin d'un clone manque." << endl;
       else
	 cerr << endl
	      << "The clone file is not complete:" << endl
	      << "the location of the end of a clone is missing." << endl;
      exit(1);
      }


if ( ( posfinclone> Ginit) || ( posfinclone <= 0))
	       {

		 if (french==1)
		   cerr << endl
			<< "Erreur sur le fichier des clones :"
			<< endl
			<< "Un clone termine en position " 
			<< posfinclone 
			<< endl
			<< "Il dborde du gnome [1,"
			<< Ginit << "]. " << endl ;
                 else
		   cerr << endl
			<< "Error on the clone file:"
			<< endl
			<< "One clone ends at location  " << posfinclone 
			<< endl
			<< "It is then not strictly contained in the genome [1,"
			<< Ginit << "]. " << endl ;
                 exit(1);
	       }

if (posdebclone>  posfinclone)
	       {
		 if (french==1)
		   cerr << endl
			<< "Erreur sur le fichier des clones :"
			<< endl
			<< "Un clone commence en position "
			<< posdebclone
			<< " et termine en position " << posfinclone 
			<< endl
			<< "ce qui est impossible."
			<<  endl ;
                 else
		   cerr << endl
			<< "Error on the clone file:"
			<< endl
			<< "One clone begins at location  " 
			<< posdebclone 
			<< " and ends at location  " << posfinclone 
			<< endl
			<< "that is not possible."
			<<  endl ;
		 exit(1);
	       }


if ( (ilu>0) && (posfinclone> pospred))
   {
   if (french==1)
        cerr << endl
	     << "Erreur sur le fichier des clones :"
	     << endl
	     << "Un clone termine en position " << posfinclone 
	      << endl
              << "alors que le prcdent termine en position " << pospred
              << endl
	      << "Rappelez-vous que les positions des ancres" << endl
              << "et les positions des fins de clones doivent" << endl
              << "tre tries en ordre dcroissant." << endl
              << "(les scripts 'sort.anchors' et 'sort.clones' peuvent vous y aider)" 
              << endl ;
    else
		   cerr << endl
			<< "Error on the clone file:"
			<< endl
             << "One clone ends at location " << posfinclone 
             << endl
             << "while the preceding one ends at location " << pospred
              << endl
              << "Recall that the anchor locations and the location" << endl
              << "of the right-hand ends of clones have to be in decreasing order"
              << endl
              << "(the scripts 'sort.anchors' and 'sort.clones' can help you)"
	      <<  endl ;
	 exit(1);
       }
ilu++;
pospred=posfinclone;


posdebclone /= max;
posfinclone /= max;

return(posdebclone);
}


//------------------CALCUL DE LA POSITION DE DEBUT DE CLONE--------------------
//------------------POUR DES PLAGES DE LONGUEURS REGULIERES--------------------

double Clone :: plagereg(double Np, double Lmin, double Lmax,double posfinclone, double G, double intervalle)

  // Np : nombre de plages.
  // Lmin : petite longueur.
  // Lmax : grande longueur.
  // posfinclone : fin de clone.

{
  double Lp;      //longueur des plages.
        
  int n;          //compteur de boucles.
   
  //initialisation de n.
  n = 0;   

  //calcul de la longueur des plages.      
  Lp = G / Np;    

  //------------Fin du clone au dela de la sequence------------------------ 
  if (posfinclone<0) return(-1);

  //------------Longueurs aleatoires des clones---------------------------- 
  if (intervalle !=0) longueurirreg(&Lmin, &Lmax,intervalle);

  //------------position du debut de clone courant-------------------------
  while ( (n * Lp) < G)
    { 
      if ((posfinclone < (n+1)*Lp) && (posfinclone > n * Lp)) 
	return(((n%2)==0)?(posfinclone-Lmin):(posfinclone-Lmax));

      n++;
    }
}




//--------------------CALCUL DE LA LONGUEUR DU CLONE DANS LE CAS----------
//--------------------OU CELLE-CI EST ALEATOIRE---------------------------
 
void Clone :: longueurirreg(double *Lmin, double *Lmax, double intervalle)
{ 
  // Lmin : petite longueur.
  // Lmax : grande longueur.
  // posfinclone : fin de clone.
  // intervalle : Variabilite des longueurs de clones.
  
  //---------------variable locale----------------------------------------
  double u;

  //-----------on tire un nombre aleatoire entre 0 et 1-------------------
  u = drand48();

  //--------on replace la valeur dans l'intervalle [0, 2*intervalle]------ 
  u = 2*intervalle*u;

  //--------on obtient la longueur du clone-------------------------------

  //Cas ou le clone est court.
  *Lmin = u+*Lmin-intervalle;

  //Cas ou le clone est long.
  *Lmax = u+*Lmax-intervalle;
}



                                                                                                   
