#include <string.h>
#include <iostream.h>
#include <stdlib.h>
#include <math.h>  
#include <fstream.h>    
#include <iomanip.h>    
#include "Element.h"
#include "Ancre.h"
#include "Clone.h"
#include "Carte.h"

//--------------------declaration des fonctions appelees-------------------
int lit_com(ifstream& ific, double & valeur);

void commun( int SIZE, int M, int N, int inter,
      double Ginit, double Np, double max, double min,
      ifstream& ificclone, ifstream& ificancre,
      ofstream& ofic,
      double&, double&, double&, double&, double&, double&);
	    
extern int french;
/* ------------------------------------------------------------
  PROGRAMME PRINCIPAL QUAND LES POSITIONS SONT LUES SUR FICHIERS
---------------------------------------------------------------- */

void main_lecture(char* ficclone, char * ficancre)
{

  //---------------------declaration des variables-----------------------------
      
  double G,Ginit,                 //longueur de la sequence.
         max=1;                   // longueur maximale des clones.

  ifstream ificclone;      // pointeur sur le fichier des positions des clones
  ifstream ificancre;      // pointeur sur le fichier des positions des ancres
  ofstream ofic;           // pointeur sur le fichier detail (ignor ici)

  double
         NbMoy,            //Nombre moyen d'iles.
         LgMoy,            //Longueur moyenne des iles.
         OceanMoy,         //pourcentage moyen des oceans.
         VarLgIle=0,        //variance de la longueur moyenne.
         VarNbIle=0,        //variance du nombre d'iles.
         VarOcean=0;        //variance du pourcentage d'ocean.

 //----------------ouverture du fichier ficclone----------------------------- 
  ificclone.open(ficclone);
  if (!ificclone.good())
    {
    if (french==1)
      cerr << " Impossible d'ouvrir le fichier " << ficclone << endl;
    else
      cerr << " Not possible to open the file " << ficclone << endl;
    exit(1);
    }

  //----------------ouverture du fichier ficancre----------------------------- 
  ificancre.open(ficancre);
  if (!ificancre.good())
    {
    if (french==1)
      cerr << " Impossible d'ouvrir le fichier " << ficancre << endl;
    else
      cerr << " Not possible to open the file " << ficancre << endl;
    exit(1);
    }

  //---------------- Lecture des en-tetes-----------------------------------
  if (lit_com(ificclone, Ginit) <0)
    {
    if (french==1)
      cerr << " Probleme sur le fichier " << ficclone << " : " << endl
           << " Impossible de lire la longueur du gnome."<< endl;
    else      
      cerr << " Error on the file " <<ficclone << ":" << endl
           << " cannot read the genome length. "<< endl;
    exit(1);
    }

if (Ginit <=0)
  {
   if (french==1)
      cerr << " Probleme sur le fichier " << ficclone << " : " << endl
	   << " La longueur du gnome (" << Ginit
	   << ") est nulle ou ngative." << endl;
   else      
      cerr << " Error on the file " <<ficclone << ":" << endl
	   << " The genome length (" << Ginit
	   << ") is null or negative." << endl;
  exit(1);
  }

  if (lit_com(ificancre, G) <0)
    {
      if (french==1)
        cerr << " Probleme sur le fichier " << ficancre << " :" << endl
             << " Impossible de lire la longueur du gnome."<< endl;
      else      
        cerr << " Error on the file " <<ficancre << ":" << endl
           << " cannot read the genome length. "<< endl;

      exit(1);
    }

if (G <=0)
  {
   if (french==1)
      cerr << " Probleme sur le fichier " << ficancre << ":" << endl
	   << " La longueur du gnome (" << G
	   << ") est nulle ou ngative." << endl;
   else      
      cerr << " Error on the file " <<ficancre << ":" << endl
	   << " The genome length (" << G
	   << ") is null or negative." << endl;
  exit(1);
  }


  //---------------- Verification-------------------------------------------
  if (G != Ginit)
	    {
            if (french==1)
	      cerr << "La longueur du gnome est gale  "
		   << Ginit << " sur le fichier des clones et  "
		   << G << " sur le fichier des ancres " << endl;
            else
	      cerr << "The genome length is equal to "
		   << Ginit << " on the clone file and to "
		   << G << " on the anchor file." << endl;
	      exit(1);
	    }


  //------------------Affichage des valeurs des variables considerees-----
if (french==1)
  {
    cout << endl
       <<"Ce programme calcule certaines proprits de la carte physique"
      << endl
      << "d'un gnome de taille " << Ginit
      << " construite par la mthode d'ancrage." << endl << endl;

  cout << "Les positions des clones et des ancres sont lues respectivement dans les fichiers"
       << endl
       << ficclone << " et " << ficancre <<"." << endl;
  }
else
  {
    cout << endl
         << "This is a program to calculate some properties of the physical"
         << endl
         << "map of a genome of length " << Ginit
         << " constructed by the anchoring approach. " << endl << endl;

    cout << "Clone and anchor locations are respectively read in the files"
       << endl
       << ficclone << " and " << ficancre <<"." << endl;
  }

  //------------------Appel du programme de calcul-----------------------
  // Les arguments nuls ne servent que pour le cas simulation
  // Le 1ier argument: en gnral, nombre de simulations (ici,1)
  // Le dernier argument est un pointeur qui ne sert aussi que pour le cas simulation

  ofic.clear(ios::badbit);

  commun(
          (int)1,(int) 0,(int)0, (int)0,
          Ginit, 
          (double)0, max,(double)0,
          ificclone, ificancre,
          ofic,
          NbMoy, LgMoy,  OceanMoy,
          VarNbIle, VarLgIle, VarOcean); 

} // fin main_lecture


/* ------------------------------------------------------------
  Programme qui saute les commentaires sur les fichiers d'entree
et renvoie la prochaine valeur double lue.
Valeur de retour: -1 si fin de fichier
Les  commentaires sont introduits par un dieze
--------------------------------------------------------------- */
int lit_com(ifstream& ific , double& valeur)
{
char c ;

// Initialisation bizarre
// mais,  sinon, ca ne marche que quand appele par le main_lecture
ific >> c;
ific.putback(c); // on remet le car lu


while(ific.get(c))
  {
    while(c == '\n')
      {
        ific.get(c);
        if (c == EOF)
          return(-1);
      }

   if  (c == '#') 
     {
       // on lit jusqu'a la fin de la ligne
      while( (c!= EOF) && (c != '\n'))
	{
          ific.get(c);
	}
     continue; // on va chercher la ligne suivante
     } // fin if (c == '#')
   else
     {
       ific.putback(c); // on remet le car lu
       ific >> valeur;
       return(0); 
     }
  }
// ici, on a rencontre la fin du fichier
return(-1);
} // FIN lit_com




/* ------------------------------------------------------------
  PROGRAMME PRINCIPAL QUAND LES POSITIONS SIMULEES
---------------------------------------------------------------- */

void main_simul(char* fic)
{
  //---------------------declaration des variables-----------------------------

  int    SIZE,                    //Nombre d'iterations. 
         inter;                   //valeur de variation de longueurs au sein
                                  //d'une plage de clones.
      
  double Ginit,                   //longueur de la sequence.
         min,                     //longueur minimale  des clones.
         max,                     // longueur maximale des clones.
         M,                       //nombre d'ancres.
         N,                       //nombre de clones.
         Np;                      //nombre de plages.

  ofstream ofic;                  //variable d'ecriture dans fichier fic.
  ifstream ific;                  // fichier d'entree ignor dans le cas simulation

  double
         NbMoy,            //Nombre moyen d'iles.
         LgMoy,            //Longueur moyenne des iles.
         OceanMoy,         //pourcentage moyen des oceans.
         VarLgIle=0,        //variance de la longueur moyenne.
         VarNbIle=0,        //variance du nombre d'iles.
         VarOcean=0;        //variance du pourcentage d'ocean.

  //----------------ouverture du fichier fic----------------------------- 
  if (fic != NULL)
    {
      ofic.open(fic);
      if (!ofic.good())
	{
	  if (french==1)
	    cerr << " Impossible d'ouvrir le fichier " << fic << endl;
	  else
	    cerr << " Not possible to open the file " << fic << endl;
	  exit(1);
	}

    //----------------commentaires du fichier fic--------------------------
   if (french==1)
      {
      ofic<<"Ce fichier contient, pour chaque iteration : "<<endl;
      ofic<<"le nombre moyen d'iles (NbIle)" << endl;
      ofic << "la longueur moyenne des iles (LgIle),"<<endl;
      ofic<<"le pourcentage d'ocean (Ocean)."<<endl<<endl; 
      }
   else
     {
      ofic<<"This file contains, for each iteration : "<<endl;
      ofic<<"the mean number of islands (NbIle)" << endl;
      ofic << "the mean length of the islands (LgIle),"<<endl;
      ofic<<"the percentage of oceans (Ocean)."<<endl<<endl; 
     }
    ofic<<"NbIle"<<"  "<<"LgIle"<<"   "<<"Ocean"<<endl;        
    } /* fin if (fic != NULL) */

else
   ofic.clear(ios::badbit);

  //----------------------------initialisation des variables-------------------
if (french==1)
  {
  cout<<"Ce programme calcule certaines proprits de la carte physique"
      << endl
      << "d'un gnome construite par la mthode d'ancrage." << endl << endl;

  cout<<"Entrez les donnes ncessaires  la ralisation de cette exprience." <<endl<<endl<<endl; 

  cout<<"Combien d'itrations voulez-vous effectuer (>0) ? "<<endl;
  cin>>SIZE;

  cout<<"Quelle est la longueur du gnome (en paires de bases) ?"<<endl;
  cin>>Ginit;

  cout<<"Quel est le nombre moyen d'ancres (>0) ?"<<endl;
  cin>>M;
 
  cout<<"Quel est le nombre moyen de clones (>0) ?"<<endl;
  cin>>N;
  
  cout<<"Combien y a t-il de plages (>0) ?"<<endl;  
  cin>>Np;

  cout<<"Quelle est la longueur des longs clones (en bases) ?"<<endl;  
  cin>>max;

  cout<<"Quelle est la longueur des courts clones (en bases) ?"<<endl;
  cin>>min; 

  cout<<"Quelle est la variabilit des longueurs au sein d'une plage de clones (en bases) ?"<<endl;
  cin>>inter;
  cout << endl << endl;  

  if (inter > min)
    {
      cerr << "La variabilit des longueurs " << inter << endl
         << " doit etre infrieure ou gale  la longueur des courts clones "
         << min << endl;
    exit(1);
    }

  //------------------Affichage des valeurs des variables considerees-----

  cout<<"Longueur du gnome (bp) : "<<Ginit<<endl;
  cout<<"Nombre moyen d'ancres : "<<M<<endl;
  cout<<"Nombre moyen de clones : "<<N<<endl;
  cout<<"Nombre de plages : "<<Np<<endl;
  cout<<"Longueur moyenne des longs clones (bp) : "<<max<<endl;
  cout<<"Longueur moyenne des courts clones (bp) : "<<min<<endl;
  cout<<"Variabilit des longueurs de clones (bp) : "<<inter<<endl<<endl;

  } // fin cas francais
else
  {
    cout << "This is a program to calculate some properties of the physical"
         << endl
         << "map of a genome constructed by the anchoring approach " << endl 
         << "from simulated data." << endl << endl;

    cout <<"Type in the data required for these simulations:" <<endl<<endl<<endl; 
    cout<<"How many simulations do you want to do (>0)? "<<endl;
  cin>>SIZE;
 
  cout<<"What is the genome length (in basepairs)?"<<endl;
  cin>>Ginit;

  cout<<"What is the mean number of anchors (>0)?"<<endl;
  cin>>M;
 
  cout<<"What is the mean number of clones (>0)?"<<endl;
  cin>>N;
  
  cout<<"How many regions do you want to consider along the genome (>0)?"<<endl;  
  cin>>Np;

  cout<<"What is the mean length of long clones (in basepairs)?"<<endl;  
  cin>>max;

  cout<< "What is the mean length of small clones (in basepairs)?"<<endl;
  cin>>min; 

  cout<< "How much variability do you allow for the clone lengths (in basepairs)?"<<endl;
  cin>>inter;
  cout << endl << endl;  

  if (inter > min)
    {
      cerr << "The variability of the lengths " << inter << endl
	   << "must be less or equal to the length of the small clones " 
         << min << endl;
    exit(1);
    }

  
  //------------------Affichage des valeurs des variables considerees-----

  cout<<"Genome length  (bp): "<<Ginit<<endl;
  cout<<"Mean number of anchors: "<< M<<endl;
  cout<<"Mean number of clones: "<< N<<endl;
  cout<<"Number of regions: "<<Np<<endl;
  cout<<"Mean length of long clones (bp): "<<max<<endl;
  cout<<"Mean length of small clones (bp): "<<min<<endl;
  cout<<"Variability of clone lengths (bp): "<<inter<<endl<<endl;

  } // fin cas anglais

  //-----------------Appel du programme de calcul-------------------------
  // Les arguments ifstream (ific) ne servent que pour le cas lecture

  ific.clear(ios::badbit);

  commun(
         SIZE, M, N, inter, Ginit, Np, max, min, 
              ific, ific,
          ofic,
          NbMoy, LgMoy,  OceanMoy,
          VarNbIle, VarLgIle, VarOcean); 

} // FIN main_simul



/* ------------------------------------------------------------
  PROGRAMME PRINCIPAL DE CALCUL
---------------------------------------------------------------- */

void commun(
      int SIZE, int M, int N, int inter,
      double Ginit, double Np, double max, double min,
      ifstream& ificclone, ifstream& ificancre,
      ofstream& ofic,
      double & NbMoy, double &LgMoy,  double &OceanMoy,
      double &VarNbIle, double &VarLgIle, double &VarOcean) 
{
// Arguments d'entree:
  // SIZE: Nombre d'iterations. (cas simulations, 1 sinon)
  // M :   Nombre d'ancres moyen (cas simulations)
  // N :   Nombre de clones(cas simulations)
  // inter:Valeur de variation de longueurs au sein d'une plage de clones.
  //      (cas simulations) 
  // Ginit:Longueur de la sequence.
  // Np:   Nombre de plages.(cas simulations) 
  // max : Longueur maximale des clones.(cas simulations)
  // min : Longueur minimale  des clones.(cas simulations) 
  // ificclone: Variable d'ecriture dans fichier des clones (cas lecture)
  // ificancre: Variable d'ecriture dans fichier des ancres (cas lecture)
  // ofic: Variable d'ecriture dans fichier detail (cas simulations)
// Arguments de sortie:
  // NbMoy : nombre moyen d'les,
  // LgMoy : longueur moyenne des les
  // OceanMoy : proportion d'ocans, 
  // VarNbIle, VarLgIle,VarOcean:  variances de ces nombres
  // Rque: l'ecart-type = sqrt(Var/SIZE)

  //---------------------declaration des variables-----------------------------

  int   
         Ile,                     //Ile = 1, si fin d'Ile, sinon, Ile = 0.
         i,
         j,
         isimul=0,                // 1  dans le cas de simulations
         ilu ;
      
  double 
         G,                       //longueur renormalisee de la sequence.
         Lmin,                    //longueur minimale renormalisee des clones.
         Lmax,                    //longueur maximale renormalisee des clones.
         FinIle,                  //fin d'ile courante.
         DebIle,                  //debut d'ile courante.
         DebIlePred,              //debut de l'ile precedente.
         Ocean,                   //pourcentage d'ocean.  
         posancre,                //position de l'ancre.
         posfinclone=-1,          //position de fin de clone.
         posdebclone,             //position de debut de clone.
         intervalle;              //valeur de variation de longueurs au sein
                                  //d'une plage de clones.
         
  double *p=new double[4*SIZE];   //creation d'un tableau qui prendra NbIle,
                                  // LgIle, LgVarIntra, ocean pour chaque 
                                  //iteration.
                                  // AB: LgVarIntra jamais affecte?




  // -----------------------verification des arguments -----------------

if (SIZE < 1)
  {
    if (french==1)
      cerr << "Le nombre d'itrations, "
           << SIZE
	   << ", doit tre suprieur ou gal  1."
	   << endl;
    else
      cerr << "The number of iterations, "
           << SIZE
	   << ", must be greater or equal to 1."
	   << endl;
    exit(1);
  }

  // ----------------verification en cas de simulations -------------------

if (ificancre == NULL)
{
  if (M <= 0)
  {
    if (french==1)
      cerr << "Le nombre  d'ancres moyen, "
	   << M
	   << ", doit tre positif."
	   << endl;
    else
      cerr << "The mean number of anchors,"
	   << M
	   << ", must be positive."
	   << endl;
    exit(1);
  }

  if (N <= 0)
  {
    if (french==1)
      cerr << "Le nombre de clones moyen, "
	   << N
	   << ", doit tre positif."
	   << endl;
    else
      cerr << "The mean number of clones,"
	   << N
	   << ", must be positive."
	   << endl;
    exit(1);
  }

  if (inter < 0)
  {
    if (french==1)
      cerr << "La variabilit des longueurs au sein d'un plage de clones, " 
	   << inter
	   << ", doit tre positive ou nulle."
	   << endl;
    else
      cerr << "The variability for the clone lengths,"
	   << inter
	   << ", must be positive or null."
	   << endl;
    exit(1);
  }

  if (Np <= 0)
  {
    if (french==1)
      cerr << "Le nombre de plages, "
	   << Np
	   << ", doit tre positif."
	   << endl;
    else
      cerr << "The number of regions, "
	   << Np
	   << ", must be positive."
	   << endl;
    exit(1);
  }


  if (max < min)
  {
    if (french==1)
      cerr << "La longueur moyenne des longs clones, "
	   << max
	   << ", doit tre suprieure ou gale  "
	   << endl
	   << "la longueur moyenne des petits clones, " 
	   << min
	   << "."
	   << endl;
    else
      cerr << "The mean length of long clones, "
	   << max
	   << ", must be greater or equal to "
	   << endl
	   << "the  mean length of small clones, "
	   << min
	   << "."
	   << endl;
    exit(1);
  }

  if ((max <=0) || ( min<=0 ))
  {
    if (french==1)
      cerr << "La longueur moyenne des longs clones, "
	   << max
	   << ", et la longueur moyenne des petits clones, " 
	   << min
	   << endl
	   << ", doivent tre positives." 
	   << endl;
    else
      cerr << "The mean length of long clones, "
	   << max
	   << ", and the mean length of small clones, "
	   << min
	   << endl
	   << ", must be positive."
	   << endl;
    exit(1);
  }

isimul =1 ;
} // fin du cas simulation


if (Ginit <= 0)
  {
    if (french==1)
      cerr << "La longueur du gnome, "
	   << Ginit
	   << ", doit tre positive."
	   << endl;
    else
      cerr << "The genome length,"
	   << Ginit
	   << ", must be positive."
	   << endl;
    exit(1);
  }


  // max : Longueur maximale des clones.
  // min : Longueur minimale  des clones.(cas simulations) 



       //----------------------renormalisation par la longueur max ------------    

//       if (ificancre == NULL)
       if (isimul ==1)
	 {
	   // cas simulation  
          intervalle = inter/max; 
	  Lmin = min/max;
	  Lmax=1;
	 } // fin cas simulation  
       else
	 max = 1 ;

       G = Ginit/max;
  
       //------------initialisation des variables DebIle, FinIle, debIlePred---
  
       FinIle = G;
       DebIle = G;
       DebIlePred = G;
  
       //--------------------------creation d'un objet ancre et clone---------
       Ancre *ancre =  new Ancre(M);
       Clone *clone = new Clone(N);


       //--------------------------SIMULATIONS (AU NOMBRE DE SIZE)-------------

       for (i=0; i<SIZE; i++)
	 {
	   //--------------------creation d'un objet carte---------------------
      
	   Carte *carte = new Carte();

 
	   //---------Simulation/Lecture des premiers ancres et clones---------
	   //           if (ificancre == NULL)
           if (isimul == 1)
	     {
	       // cas simulation  
	       //simulation d'une position d'ancre.
	       posancre=ancre->simule(G,G);
	  
	       //simulation d'une position de fin de clone.         
	       posfinclone = clone->simule(G,G);
       
	       //simulation d'une position de debut de clone.         
	       posdebclone = clone->plagereg(Np,Lmin,Lmax,posfinclone,G,intervalle);
	     } // fin  cas simulation
	   else
	     {
	       // cas lecture
	       //lecture d'une position d'ancre.
	       posancre=ancre->litancre(ificancre, Ginit, max);
	       if ( posancre <0)
		 {
		   if (french==1)
		     cerr << "Fin prmature du fichier des ancres :"  << endl
		      << "la position de la premiere ancre manque." << endl;
	       else
		 cerr << "The anchor file is not complete:" << endl
		      << "the location of the first anchor is missing." << endl;

               exit(1);
	       }

	       //lecture d'une position de clone
	   
	       posdebclone = clone->litclone(ificclone,posfinclone, Ginit, max );
	       if (posdebclone <0)
	       {
               if (french==1)
		 cerr << "Fin prmature du fichier des clones :"  << endl
		      << "la position du dbut ou de la fin du premier clone" << endl
		      << "manque." << endl;
	       else
		 cerr << "The clone file is not complete:" << endl
		      << "the location of the beginning or of the end" << endl
		      << "of the first clone is missing." << endl;

               exit(1);
	       }
	     } // fin  cas lecture

	   
	   //----------------------Parcours de la sequence d'ADN---------------

	   while ((posancre>=0) && (posdebclone>=0))   
	     { 
	       while (posancre>posfinclone)  
		 {
             
		   //Tant que l'ancre n'est pas susceptible d'appartenir au clone 
		   //on recommence a simuler/lire une nouvelle ancre.
		   if (isimul == 1)
		     posancre=ancre->simule(G,posancre);
		   else
		     posancre=ancre->litancre(ificancre, Ginit, max);

		   //La position de l'ancre sort de la sequence d'ADN.
		   if (posancre<0)  break;
	   
		 }   //fin de tant que.(posancre>posfinclone)
      
	       if (posancre>=0) 
		 {
         
		   //On remet ile a zero car on a termine une Ile.
		   if (posancre<DebIle) Ile=0;    

		   while (posancre<posdebclone)
		     {
                 
		       //tant que le clone n'est pas susceptible d'etre ancre 
		       //on recommence a simuler/lire un nouveau clone.
		       if (isimul == 1)
			 {
			   //simulation d'une position de fin de clone. 
			   posfinclone = clone->simule(G,posfinclone);
		  
			   //simulation d'une position de debut de clone.
			   posdebclone = clone->plagereg(Np,Lmin,Lmax,posfinclone,G,intervalle);
			 } // fin (isimul == 1)
		       else
			 {
			   posdebclone = clone->litclone(ificclone, posfinclone,
                                       Ginit, max);
			 }


		       //La position de debut de clone sort de la sequence d'ADN.
		       if (posdebclone < 0) break;
		       
		     }  //fin de tant que.(posancre<posdebclone)

		   if ((posdebclone >= 0) && (posancre <= posfinclone))
		     {
                 
		       //On a un clone ancre.
		       //allongement de l'ile ou mise a jour des differentes valeurs 
		       //caracterisant une ile  si on a commence une nouvelle ile.   
         
		       carte->allongile(&FinIle, &DebIle, &DebIlePred, posfinclone, posdebclone, &Ile,G);
                  

		       //On simule/lit un nouveau clone.
		       if (isimul == 1)
			 {
			   //simulation d'une position de fin de clone. 
  			   posfinclone = clone->simule(G,posfinclone);
			   //simulation d'une position de debut de clone. 
			   posdebclone = clone->plagereg(Np,Lmin,Lmax,posfinclone,G,intervalle);
			 }
		       else
			 posdebclone = clone->litclone(ificclone, posfinclone,
                            Ginit, max);

		  
		     }  //fin de alors.

		 }    //fin de alors.
	     }     //fin de tant que.


          if ( (ilu= clone->nombrelu()) >0)
	     {
	       //---cas lecture sur fichiers------------------------------
	       //-----Ecriture du nombre d'ancres et de clones lus ------------
               if (french==1)
                 cout << endl << "Nombre de clones considrs : " 
                    << ilu
		      << endl << "Nombre d'ancres considres : "
		      << ancre->nombrelu() << endl << endl;
	       else
		 cout << endl << "Number of clones taken into account: " 
                    << ilu
		      << endl << "Number of anchors taken into account: "
		      << ancre->nombrelu() << endl << endl;
	     } // fin  (isimul)



	   //----On comptabilise l'ocean et on calcule le pourcentage d'ocean--
	   //-----------------et la longueur moyenne d'une ile-----------------
      
      
	   carte->maj(DebIlePred,DebIle,FinIle);
      

	   //--------------mise a jour finale des variables--------------------

	   if (!ofic)
	
	
	     //cas ou on ne met pas les valeurs dans le fichier fic.
	     carte->majfin(&DebIle, &FinIle, &DebIlePred, G, i, p, max, SIZE);
	
	   else

	     //cas ou on met les valeurs dans le fichier fic. 
	     // i.e fichier detail, dans le cas simulation
	     carte->majfin(&DebIle, &FinIle, &DebIlePred, G, i, p, max, ofic, SIZE);


	   //--------------suppression de l'objet carte------------------------
   
	   delete(carte);       

	 }   //fin de boucle for.

       //---------------------creation d'un objet carte------------------------

       Carte *carte = new Carte();

       //--------------------calcul des valeurs moyennes-----------------------

       carte->statistiques(p, SIZE);


       
       //------------------- Remplissage des arguments de sortie-------------
       carte->getmoy(NbMoy, LgMoy, OceanMoy);

       if (SIZE>1)
	 {
	  carte->getvar( VarNbIle ,VarLgIle, VarOcean);
	 }

       //--------------------Ecriture des resultats----------------------------  
       cout << endl << endl ;
       cout.setf(ios::fixed, ios::floatfield);

      if (isimul ==1)
	{ 
	  // cas simulation
	  if (french==1)
	    {
	      cout << "RSULTATS:" << endl
		   << "Nombre moyen d'les ancres :            " 
		   << setprecision(2)
		   << NbMoy ;
              if ( VarNbIle > 0)
		cout <<" (+/- " 
	              << setprecision(4)
                      << sqrt(VarNbIle/SIZE) << ") " ;
	      else
                cout <<" (+/- 0) " ;
              cout << endl
		   << "Longueur moyenne des les ancres (bp) : " 
		   << setprecision(2)
                   << LgMoy ;
              if ( VarLgIle > 0)
		cout <<" (+/- " 
	              << setprecision(4)
                     << sqrt(VarLgIle/SIZE) << ") " ;
	      else
                cout <<" (+/- 0) " ;
              cout << endl
		   << "Proportion moyenne d'ocans :             " 
		   << setprecision(4)
                   << OceanMoy ;
              if ( VarOcean > 0)
		cout <<" (+/- " 
	              << setprecision(4)
                    << sqrt(VarOcean/SIZE) << ")" ;
	      else
                cout <<" (+/- 0) " ;
	    }
	  else
	    {
	      cout << "RESULTS:" << endl
		   << "Mean number of anchored islands:        " 
		   << setprecision(2)
		   << NbMoy ;
              if ( VarNbIle > 0)
		cout <<" (+/- " 
		   << setprecision(4)
		     << sqrt(VarNbIle/SIZE) << ") " ;
	      else
                cout <<" (+/- 0) " ;
              cout << endl
		   << "Mean length of an anchored island (bp): " 
		   << setprecision(2)
		   << LgMoy ;
              if ( VarLgIle > 0)
		cout <<" (+/- " 
		   << setprecision(4)
		     << sqrt(VarLgIle/SIZE) << ") " ;
	      else
                cout <<" (+/- 0) " ;
              cout << endl
		   << "Mean proportion of oceans:              " 
		   << setprecision(4)
		   << OceanMoy ;
              if ( VarOcean > 0)
		cout <<" (+/- " 
		   << setprecision(4)
		     << sqrt(VarOcean/SIZE) << ") " ;
	      else
                cout <<" (+/- 0) " ;
	    }
	} // fin SIZE>1

      else
	{

	  // cas lecture sur fichier
	  if (french ==1)
		{
		  cout <<  "Voici les rsultats :" << endl << endl 
                     << "On obtient "
		       << setprecision(0)
	             << NbMoy 
		     << " les ancres," 
	             << endl
                     << "d'une longueur moyenne de " 
		       << setprecision(2)
		     << LgMoy << " bases"
	             << endl << "et couvrant " 
                     << (( (double)1-OceanMoy)*(double)100)
		     << " pourcent du gnome.";
		}
	      else
		{
		  cout << "Here are the results:" << endl << endl
                       << "One obtains " 
		       << setprecision(0)
	               << NbMoy << " anchored islands," 
                       << endl
	               << "with an average length of " 
		       << setprecision(2)
                       << LgMoy << " bases" 
	               << endl << "and covering "  
		       << (( (double)1-OceanMoy)*(double)100)
		       << " percent of the genome.";
		}
	} // fin cas lecture sur fichier
      cout << endl << endl;


}// fin de commun
